(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1073524,      25488]
NotebookOptionsPosition[   1024079,      24658]
NotebookOutlinePosition[   1024549,      24675]
CellTagsIndexPosition[   1024506,      24672]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Cyclic Quadrilaterals", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, 
   3.947147906503248*^9, {3.9471622861437607`*^9, 
   3.9471622877509346`*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about cyclic quadrilaterals \
in the paper \"More Relationships between a Central Quadrilateral and its \
Reference Quadrilateral\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in \
February 2025.

This Notebook is Copyright \[Copyright] February 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947162294038662*^9, 
  3.947162295062664*^9}},ExpressionUUID->"08758b0a-705f-b842-b1d6-\
6a28a79b6218"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ptD", "=", 
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"condition", " ", "of", " ", "cyclicity"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"cyclic", "=", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{"circunscrita", ",", "ptD"}], "]"}], "==", "0"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9471624606466045`*^9, 3.9471624614180145`*^9}, 3.947162515937668*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{3.9471628770241*^9, 3.947163230027064*^9, 
  3.947171547777752*^9, 3.947384354750984*^9, 3.947404248747368*^9, 
  3.947433914907507*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"bc48e105-3742-7b46-bd71-c76319925060"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"cf60f297-bbcd-8748-b453-\
e7118b4e0a98"],

Cell[CellGroupData[{

Cell["QAP centers", "Subsection",
 CellChangeTimes->{{3.945853740709931*^9, 3.945853743438184*^9}, {
  3.9464394595455627`*^9, 
  3.9464394652171745`*^9}},ExpressionUUID->"c8cca55e-04f1-8f4a-b670-\
3c3179eed91e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP", "=", 
   RowBox[{"<|", 
    RowBox[{
     RowBox[{"1", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ",", 
        RowBox[{"p", "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ",", 
        RowBox[{"p", "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}]}], "}"}]}], ",", 
     RowBox[{"2", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "SB"}], "-", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "SA"}], "+", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "SA"}], "-", 
           RowBox[{"q", " ", "SB"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"3", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
          ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"4", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "q", " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "r", " ", "SA"}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}],
         ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p"}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q"}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"5", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"6", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"7", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 SuperscriptBox["SB", "2"], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}], "+", 
                 SuperscriptBox["SC", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "r", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"r", " ", "SC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SC"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SC"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "q", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"q", " ", "SB", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SB"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SB"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SB"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
        "}"}]}], ",", 
     RowBox[{"8", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "r", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"9", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p", " ", "q"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"]}], "+", 
                 RowBox[{"3", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "-", 
                 SuperscriptBox["r", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "p", " ", "q"}], "-", 
                 SuperscriptBox["q", "2"], "+", 
                 RowBox[{"2", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "-", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"5", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "8"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "8"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"8", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"4", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["c", "6"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["p", "2"]}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["p", "2"], "-", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "6"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"5", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "-", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "3"}], " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  SuperscriptBox["q", "3"], " ", "r"}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "3"]}], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"8", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["q", "2"]}]}], ")"}], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "6"]}], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["p", "2"]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "-", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"6", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"10", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"11", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"12", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SB"}], "+", 
           RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q", " ", 
            SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"13", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"14", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}]}], "}"}]}], 
     ",", 
     RowBox[{"15", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["p", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"22", " ", "q", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["q", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "q"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"10", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"16", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"17", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["q", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"18", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"19", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"20", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"21", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"22", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"23", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SB"}]}]}], "}"}]}], ",", 
     RowBox[{"24", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", "SB", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SB"}], "-", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"25", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"26", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"5", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"5", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"5", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"27", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["p", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "3"]}], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           SuperscriptBox["q", "4"], "+", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["p", "3"], " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"2", " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           SuperscriptBox["r", "4"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"28", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "4"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", "r"}]}], 
             ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "4"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "+", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["a", "2"], "-", 
                   SuperscriptBox["b", "2"]}], ")"}], " ", "p", " ", "q"}], 
                "+", 
                RowBox[{
                 SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"29", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["a", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"30", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q"}], ")"}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "q"}], ")"}], " ", "r", 
            " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "q"}]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"31", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"32", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"33", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SB"}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"34", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "q"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"35", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"12", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"15", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"12", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"36", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "q"}], "-", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "-", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", "r"}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "4"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["b", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["b", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "4"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"37", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SB"}], "+", 
            RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"38", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["b", "2"]}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "-", "q", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "p"}], "+", "q", "+", "r"}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "-", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "-", 
                   RowBox[{"2", " ", "r"}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          ")"}]}]}], "}"}]}], ",", 
     RowBox[{"39", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "-", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "p"}], "+", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["a", "2"], "-", 
                 SuperscriptBox["b", "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"40", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "p"}], "+", 
                   RowBox[{"2", " ", "q"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "p"}], "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "q"}], "+", 
                  RowBox[{"9", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"9", " ", "p"}], "+", 
                  RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"12", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "q"}], "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "q"}], "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], "+", 
            SuperscriptBox["b", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "p"}], "+", 
                  RowBox[{"9", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "p"}], "+", 
                   RowBox[{"3", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", 
                  RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"41", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"42", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"43", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"44", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "q"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p", " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}]}], "|>"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945841589546528*^9, 3.945841604944151*^9}, {
   3.9458416486015606`*^9, 3.945841701130226*^9}, 3.94584180266897*^9, {
   3.945841855521532*^9, 3.945841865133842*^9}, {3.9458419743855267`*^9, 
   3.94584197851943*^9}, {3.945842012120521*^9, 3.945842016064451*^9}, {
   3.945842114756489*^9, 3.945842119338508*^9}, {3.945842170028664*^9, 
   3.945842174123476*^9}, {3.945842254968681*^9, 3.9458422593104534`*^9}, {
   3.94584246069957*^9, 3.945842465998068*^9}, {3.945842501032144*^9, 
   3.9458425325383263`*^9}, {3.945842735167492*^9, 3.945842742091593*^9}, {
   3.945842846919035*^9, 3.945842850061655*^9}, {3.945842936494915*^9, 
   3.945842969633366*^9}, {3.945843125849571*^9, 3.94584313274209*^9}, {
   3.945843174894972*^9, 3.945843178277809*^9}, {3.9458432197775517`*^9, 
   3.9458432370243473`*^9}, {3.945843287330616*^9, 3.9458432907977543`*^9}, {
   3.945843326923149*^9, 3.9458433430906563`*^9}, {3.945843384493232*^9, 
   3.945843387811741*^9}, {3.945843423557177*^9, 3.945843427076299*^9}, {
   3.9458460856414566`*^9, 3.9458460903603935`*^9}, {3.9458461244501*^9, 
   3.945846127392929*^9}, {3.945846273464027*^9, 3.945846279270181*^9}, {
   3.945846311960058*^9, 3.945846315350111*^9}, {3.945846366817175*^9, 
   3.945846382831234*^9}, {3.945846756353731*^9, 3.9458467662170296`*^9}, {
   3.945846811099188*^9, 3.945846841686339*^9}, {3.945846884211832*^9, 
   3.945847260236458*^9}, {3.945847371762398*^9, 3.9458473779483223`*^9}, {
   3.945847468577452*^9, 3.945847473866535*^9}, {3.9458476375888367`*^9, 
   3.945847641254919*^9}, {3.945847770316178*^9, 3.9458477741893463`*^9}, {
   3.94584781182493*^9, 3.9458478153183575`*^9}, {3.94584788583465*^9, 
   3.945847888720951*^9}, {3.94584794845273*^9, 3.9458479545306664`*^9}, {
   3.945848036235821*^9, 3.945848039850874*^9}, {3.945848209145437*^9, 
   3.945848213365254*^9}, {3.945848428704586*^9, 3.945848437990104*^9}, {
   3.945848526693582*^9, 3.945848534626331*^9}, {3.945848666528978*^9, 
   3.94584868269029*^9}, {3.945848775077949*^9, 3.945848778998434*^9}, {
   3.945848877398905*^9, 3.945848886629158*^9}, {3.9458491238654*^9, 
   3.945849128054989*^9}, {3.945849197156975*^9, 3.9458492011715355`*^9}, {
   3.9458492397412167`*^9, 3.945849244243763*^9}, 3.945849479846901*^9, {
   3.945851715909244*^9, 3.945851732617178*^9}, 3.945853235726444*^9, {
   3.945853633264748*^9, 3.9458536354922667`*^9}, {3.946058981146543*^9, 
   3.946058983238126*^9}, {3.946113816440451*^9, 3.946113833217655*^9}, 
   3.946113923272053*^9, 3.9462998579964046`*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],

Cell[CellGroupData[{

Cell["QAP constructions", "Subsection",
 CellChangeTimes->{{3.946258018000845*^9, 3.9462580514460297`*^9}, {
  3.946439582465828*^9, 
  3.94643958360841*^9}},ExpressionUUID->"79ef6085-3de7-3c49-8561-\
f943fbd2d431"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258220966779*^9, 3.946258253166219*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP2", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"PonceletPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258127112749*^9, 3.946258205014044*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP3", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258267006763*^9, 3.946258272798765*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP4", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP5", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "P"}], 
      "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "Q"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946552139912605*^9, 3.946552177047758*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP6", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Medio", "[", 
    RowBox[{
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554002925066*^9, 3.946554042045203*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP7", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Q1", ",", "Q2", ",", "Q3", ",", "Q4", ",", "R1", ",", "R2"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Q1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q3", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q4", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q2", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q1", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R1"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}, {3.946290848591799*^9, 
  3.946291021534954*^9}, {3.946291111031261*^9, 3.946291120455242*^9}, {
  3.946696200711548*^9, 3.946696200806263*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MiquelPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"U", ",", "V", ",", "O1", ",", "O2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"U", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"V", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O1", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O2", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"S", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"O1", ",", "O2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946294457093628*^9, 3.946294688202664*^9}, {
   3.9462961458488*^9, 3.9462961471441994`*^9}, 3.9462963028076897`*^9, {
   3.9462973681984005`*^9, 3.946297370950136*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiquelCircle", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"U", ",", "V", ",", "W", ",", "O1", ",", "O2", ",", "O3"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"U", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"V", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O1", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O2", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O3", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"Q", ",", "R", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"O1", ",", "O2", ",", "O3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946295931650831*^9, 3.9462959921519623`*^9}, {
  3.9462960978401566`*^9, 3.946296126960247*^9}, {3.946296309416164*^9, 
  3.946296387663599*^9}, {3.946296507206955*^9, 3.946296515015978*^9}, {
  3.9462965951590157`*^9, 3.9462966339272327`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP8", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SimetriaCentral", "[", 
    RowBox[{
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554262541748*^9, 3.946554276084837*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP9", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"c1", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c2", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "S", ",", "R"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c3", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "R", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CentroRadical", "[", 
      RowBox[{"c1", ",", "c2", ",", "c3"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9462975678957386`*^9, 3.94629768995805*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP10", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Baricentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554372389721*^9, 3.94655438207695*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP11", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Circuncentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554416053346*^9, 3.946554423653038*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP12", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP34", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"P1", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P2", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P3", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P4", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"QAP2", "[", 
       RowBox[{"{", 
        RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946362022452154*^9, 3.9463621697479362`*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],

Cell[CellGroupData[{

Cell["Auxiliary functions", "Subsection",
 CellChangeTimes->{
  3.818667972143658*^9, {3.8186680382464933`*^9, 3.818668041714528*^9}, {
   3.818668136826049*^9, 3.818668143553762*^9}, {3.818685183717651*^9, 
   3.818685185711126*^9}},ExpressionUUID->"d004e03f-8f12-9a43-865f-\
339812029417"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EqualPointsQ", "[", 
      RowBox[{"ptP_", ",", "ptQ_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cross", "[", 
           RowBox[{"ptP", ",", "ptQ"}], "]"}], "/.", "sustS"}], "/.", 
         "sustC"}], ",", "cond"}], "]"}], "===", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.947132996916015*^9, 3.9471330125156*^9}, {
  3.947133479684403*^9, 3.947133480044634*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quadrilateral routines", "Subsection",
 CellChangeTimes->{{3.945509919017998*^9, 
  3.945509932600797*^9}},ExpressionUUID->"2a49be25-3c4e-430e-86c6-\
869880736f30"],

Cell[CellGroupData[{

Cell["Vertex centroid", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132319963703*^9, 
  3.947132328106987*^9}},ExpressionUUID->"a576f9af-1f5b-4213-b4d3-\
e7b66981337e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3Qd8FGX+P3D+v7v7nb+zAPZTT7EgoJyn56moZ0fQKBq6dIggATVSgmBo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    "], {{0, 389.2075471698113}, {491.0943396226415, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{491.0943396226415, 389.2075471698113},
  PlotRange->{{0, 491.0943396226415}, {0, 389.2075471698113}}]], "Text",
 CellChangeTimes->{
  3.945509787103263*^9},ExpressionUUID->"f7950398-57cb-4ee6-bf14-\
597b39eb91df"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "Q"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "S"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.946439211017157*^9, 3.946439211737526*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],

Cell[CellGroupData[{

Cell["Poncelet point", "Subsubsection",
 CellChangeTimes->{{3.945509682961616*^9, 3.945509705247427*^9}, {
   3.945516718286007*^9, 3.945516720220911*^9}, 
   3.947132291355841*^9},ExpressionUUID->"f7957972-a4e9-446f-bafd-\
6774f0dd3699"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "PuntoDePoncelet", " ", "is", " ", "implemented", " ", "in", " ", "the", 
    " ", "baricentricas", " ", "package"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PonceletPoint", "[", 
     RowBox[{"{", 
      RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
    RowBox[{"PuntoDePoncelet", "[", 
     RowBox[{"P", ",", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.9455167413982186`*^9, 3.945516826125304*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],

Cell[CellGroupData[{

Cell["Steiner point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132277507908*^9, 
  3.947132283924074*^9}},ExpressionUUID->"ae32c2db-9871-344f-aabd-\
a2543db56100"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "X", ",", "Y", ",", "Z", ",", "T", ",", "U", ",", "V", ",", "W"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"X", ",", "Y", ",", "Z", ",", "U", ",", "T"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Apply", "[", 
          RowBox[{"Medio", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"P", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"R", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"S", ",", "Q"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"V", ",", "W"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Circuncentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"X", ",", "Y", ",", "U"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Y", ",", "Z", ",", "T"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"Y", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"V", ",", "W"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.945518206235336*^9, 3.945518260181164*^9}, {
  3.945518437370175*^9, 3.9455184493471375`*^9}, {3.947132243612131*^9, 
  3.947132244379742*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Diagonal point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
   3.945521331783347*^9, 3.9455213360947638`*^9}, 
   3.947132343027188*^9},ExpressionUUID->"29f12ada-9fd0-4747-b323-\
2cf96d6fb52e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"P", ",", "R"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.945521346455207*^9, 3.9455213813107405`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],

Cell[CellGroupData[{

Cell["Central quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.9464416787367783`*^9, 3.946441687230852*^9}, 
   3.947147898383025*^9},ExpressionUUID->"5a543829-5641-9144-8dd0-\
57eb7cf1938d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentralQuadrilateral", "[", "n_", "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}]}], "]"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellLabel->"In[30]:=",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],

Cell[CellGroupData[{

Cell["Area of a quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 
  3.945509840152308*^9}},ExpressionUUID->"e039afe9-d89d-4ec4-94b9-\
ddb3f9f259e0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AreaQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}], "+", 
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"R", ",", "S", ",", "P"}], "}"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Perspective quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, {3.946093948975952*^9, 3.946093951552325*^9}, 
   3.94619393871496*^9, 
   3.947147899655007*^9},ExpressionUUID->"bd16b166-d506-5544-b5d0-\
7aa6edfca35b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PerspectiveQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "R2"}], "]"}]}], "}"}], "]"}], "==", "0"}], "&&", 
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "S2"}], "]"}]}], "}"}], "]"}], "==", 
    "0"}]}]}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946093956887635*^9, 
  3.9460940140877304`*^9}, {3.9460946192084503`*^9, 3.9460946637685833`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],

Cell[CellGroupData[{

Cell["Similar and homothetic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.9471326902197247`*^9, 3.9471326941873684`*^9}, {
  3.947132774954735*^9, 
  3.947132785771118*^9}},ExpressionUUID->"d546f79d-5ed9-4f99-846e-\
3ac1a3756b86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SimilarQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}, {
  3.9455189375627*^9, 3.945519039097607*^9}, {3.945519562008997*^9, 
  3.945519564865857*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Congruent quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, 3.946437820730978*^9, 
   3.9471479009831057`*^9},ExpressionUUID->"8f461d45-0647-c84b-9fe0-\
f72d3601c63f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CongruentQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "Q1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "Q2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q2", ",", "R2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R1", ",", "S1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R2", ",", "S2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S1", ",", "P1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S2", ",", "P2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "R2"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946287549140295*^9, 
  3.946287549827748*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthogonal quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946437760717503*^9, 3.9464377702703495`*^9}, 
   3.947147903551467*^9},ExpressionUUID->"54169a90-c35c-7a4a-a37f-\
78c9753e8eeb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrthogonalQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "Q1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"P2", ",", "Q2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "R1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q2", ",", "R2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "S1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R2", ",", "S2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "P1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S2", ",", "P2"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}, {
  3.9460039858449364`*^9, 3.946003994260566*^9}, {3.946004044908913*^9, 
  3.946004131276815*^9}, {3.946004174101141*^9, 3.946004205589377*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],

Cell[CellGroupData[{

Cell["Conconic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946188760871956*^9, 3.946188779525741*^9}, {
  3.9464378271237335`*^9, 
  3.946437830963283*^9}},ExpressionUUID->"e126572d-bdab-a047-b925-\
c2661290f09e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "returns", " ", "TRUE", " ", "if", " ", "ABCD", " ", "and", " ", "EFGH", 
    " ", "are", " ", "conconic"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"conconicQuadQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_", ",", "ptD_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE_", ",", "ptF_", ",", "ptG_", ",", "ptH_"}], "}"}]}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "conic", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"conic", "=", 
        RowBox[{"ConicaCincoPuntos", "[", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], 
          "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sustituirxyz", "[", 
            RowBox[{"conic", ",", "#"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], "==", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.946440275192674*^9, 3.946440364775547*^9}, {
  3.946557553720074*^9, 3.94655756021654*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],

Cell[CellGroupData[{

Cell["Find QA center", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.946186993811855*^9, 
  3.946187000755444*^9}},ExpressionUUID->"1d12da59-37f1-9842-ad9c-\
eb916041816f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "findQACenter", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"findQACenter", "[", 
    RowBox[{"ptP_", ",", 
     RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"found", "=", "0"}], ",", "sustCS", ",", 
       RowBox[{"nc", "=", 
        RowBox[{"Length", "[", "QAP", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sustCS", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"sustS", ",", "sustC"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "<=", "nc"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Simplify", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Cross", "[", 
                   RowBox[{"ptP", ",", 
                    RowBox[{"QAP", "[", "i", "]"}]}], "]"}], "//.", 
                  "sustCS"}], ",", "cond"}], "]"}], ")"}], "==", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
             RowBox[{
              RowBox[{"found", "=", "i"}], ";", 
              RowBox[{"Break", "[", "]"}]}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<Identifying the center... \>\"", ",", 
           RowBox[{"ProgressIndicator", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "nc"}], "}"}]}], "]"}], ",", "\"\< \>\"", ",",
            "i", ",", "\"\</\>\"", ",", "nc"}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"found", "==", "0"}], ",", "\"\<unknown\>\"", ",", 
        RowBox[{"\"\<QA-P\>\"", "<>", 
         RowBox[{"ToString", "[", "found", "]"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.946187173054329*^9, 3.946187213931603*^9}, {
   3.946187246486248*^9, 3.9461872843092823`*^9}, 3.946187365054121*^9, {
   3.946187480278492*^9, 3.9461874874540024`*^9}, 3.9461880462086487`*^9, {
   3.9461881054797783`*^9, 3.9461881291423397`*^9}, {3.946188268454359*^9, 
   3.9461883008316956`*^9}, {3.94618835627853*^9, 3.946188455318756*^9}, 
   3.946257761266403*^9, {3.946258916015583*^9, 3.94625896478343*^9}, {
   3.946259615877109*^9, 3.946259655534961*^9}, {3.947132891348004*^9, 
   3.947132924188181*^9}, {3.9471329718839912`*^9, 3.9471329845888424`*^9}, {
   3.947133025988367*^9, 3.94713303106756*^9}, {3.9471334511324472`*^9, 
   3.94713348841169*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cyclic quadrilateral routines", "Subsection",
 CellChangeTimes->{{3.945509919017998*^9, 3.945509932600797*^9}, {
  3.947162988550743*^9, 
  3.9471629928866825`*^9}},ExpressionUUID->"40e5692f-48f3-024d-af81-\
1a5914b0813b"],

Cell[CellGroupData[{

Cell["Circumcenter of a cyclic quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.945610802689909*^9, 3.945610812713859*^9}, {3.9456119081446075`*^9, 
  3.9456119094484024`*^9}},ExpressionUUID->"9332bfd4-b794-9542-bea9-\
284a11b178c6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Circuncentro", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
   3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
   3.9455136200666037`*^9}, {3.94561082469837*^9, 3.94561088310631*^9}, 
   3.94561179568902*^9, {3.945611920705227*^9, 3.945611942711619*^9}, 
   3.945616284586939*^9, 3.946652944770241*^9},
 CellLabel->"In[40]:=",ExpressionUUID->"5bc10ce3-9329-a946-86e7-d45107084797"]
}, Closed]],

Cell[CellGroupData[{

Cell["Anticenter of a cyclic quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.945610802689909*^9, 
  3.945610812713859*^9}},ExpressionUUID->"4a989280-28db-ca4e-bb0b-\
101f688af051"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvV1sU1f6/7t1zs258MXxZS4icRRZygVShaxIJwhV8UUQyFKCQFYUiCwb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    "], {{0, 470.71698113207543`}, {687.3962264150942, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{687.3962264150942, 470.71698113207543`},
  PlotRange->{{0, 687.3962264150942}, {0, 470.71698113207543`}}]], "Text",
 CellChangeTimes->{3.946004699225712*^9, 3.946093819523939*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"113413b2-0b67-2b41-9e95-6ce395a68d94"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "4", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945615970386856*^9, 3.945615990738682*^9}, {
  3.945616055354908*^9, 3.945616056555292*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"80d07db2-b412-a249-8575-62ea6579cc8c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Det", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Recta", "[", 
       RowBox[{"ptA", ",", "ptE"}], "]"}], ",", 
      RowBox[{"Recta", "[", 
       RowBox[{"ptB", ",", "ptF"}], "]"}], ",", 
      RowBox[{"Recta", "[", 
       RowBox[{"ptC", ",", "ptG"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"cyclic", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.945616063892462*^9, 3.94561615265847*^9}, 
   3.945616195998407*^9, {3.945616235402563*^9, 3.945616239194622*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"77841308-7f6b-cd46-a7ee-3ab0abd88dc2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "4"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "p"}], "+", "q"}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "q"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "r"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"q", "-", "r"}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.945616132242279*^9, 3.9456161534983864`*^9}, 
   3.945616239883318*^9, 3.946004699315471*^9, 3.94609382722101*^9, 
   3.94628605964624*^9, 3.946286115022316*^9, 3.9463041366547737`*^9, 
   3.9463542991639366`*^9, 3.946641450487358*^9, 3.946651644201889*^9, 
   3.94666495833173*^9, 3.946704343778169*^9, 3.9470095409741*^9, 
   3.9470458183663616`*^9, 3.947163230856423*^9, 3.9471715489457254`*^9, 
   3.947384358023747*^9, 3.947404255059824*^9, 3.9474339161337013`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"8a57298e-6b1b-4e4a-bd94-f72bce37a22a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Det", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Recta", "[", 
       RowBox[{"ptA", ",", "ptE"}], "]"}], ",", 
      RowBox[{"Recta", "[", 
       RowBox[{"ptB", ",", "ptF"}], "]"}], ",", 
      RowBox[{"Recta", "[", 
       RowBox[{"ptD", ",", "ptH"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"cyclic", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.94561616454653*^9, 3.945616176514675*^9}, 
   3.945616209284635*^9, {3.945616251434223*^9, 3.94561625544273*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"50b1474a-8391-ca4a-aad2-5206c808fb4f"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["a", "4"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "p"}], "+", "q"}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "q"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "r"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["c", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.9456161774445515`*^9, 3.945616256355671*^9, 
  3.946004699341404*^9, 3.946093827246943*^9, 3.9462860597190437`*^9, 
  3.946286115044258*^9, 3.946304136680708*^9, 3.946354299188868*^9, 
  3.946641450515772*^9, 3.946651644225818*^9, 3.9466649583586617`*^9, 
  3.9467043438031025`*^9, 3.947009541000035*^9, 3.947045818392288*^9, 
  3.9471632309232426`*^9, 3.947171549013541*^9, 3.9473843581085258`*^9, 
  3.947404255129637*^9, 3.9474339162054768`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"f5f6c2fd-849d-874a-97cd-d95759625ac3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Medio", "[", 
    RowBox[{"P", ",", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
   3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
   3.9455136200666037`*^9}, {3.94561082469837*^9, 3.94561088310631*^9}, 
   3.94561179568902*^9, 3.946652955754562*^9},
 CellLabel->"In[44]:=",ExpressionUUID->"448ea2bb-3258-a841-a2d3-d7177e41cebf"]
}, Closed]],

Cell[CellGroupData[{

Cell["Centrocenter of a cyclic quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.945610802689909*^9, 3.945610812713859*^9}, {3.945611043737335*^9, 
  3.945611045361271*^9}},ExpressionUUID->"6221cf63-919d-e141-8412-\
466cad561c91"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQ1wVGd673mym9rdSqlqV9lkUl0JG3IVZTV7ufEwSk8FD5nbqhu0zOgO
7R0vUWFIW9IVV3iJI2yvJOSLMBnUdpmmwJKwsT3TZbcWTzQTnzC2PGM147YN
VmAY2tPyAGHaA7KFhGLAjaxqJAFSt/Y95+1udZ/39Mfpj/PR5/+rU5SQjs7X
+/aj53/e5+NPWtq/81//O47jnvifyD/fae6qe/zx5u4H/xfyn81//8QjbX+/
vfWbf///bm/b/vhftvz35Jv/629x3P/x2xwnfL0MVAGPGqgGJhsAwJzA+gEA
QAKYRKAamGwAAHMC6wcAAAlgEoFqYLIBAMwJrB8AACSASQSqgckGADAnsH4A
AJAAJhGoBiYbAMCcwPoBAEACmESgGphsAABzAusHAAAJYBKBamCyAQDMCawf
AAAkgEkEqoHJBgAwJ7B+AACQACYRqAYmGwDAnMD6AQBAAphEoBqYbAAAcwLr
J8eM39XACWx2Bxe0vhgAgHrAJALVwGQDAJgTWD+GSNh/yMZxUB8AmBCYRKAa
mGwAAHMC6yclcsldb+FsDzlsFo6r7fTd1PqCAADqAZMIVAOTDQBgTmD9Urk7
xe+0cA0uf9DXWctxlnr3pYjW1wQAUA2YRKAamGwAAHMC65dMZIpvsXCWFn4q
chPqAwATApMIVAOTDQBgTmD9Voh8yres4Sw7+am7y8sLQfdm8nAsnb5Zra8L
AKAaMIlANTDZAADmBNYvTmTW123h1rTwn4qLHTH1wdW7g1j8AMA0wCQC1cBk
AwCYE1i/GOGzLpuFsx3yh6nYoGIE6gMAcwGTCFQDkw0AYE5g/URog48Gl38m
/p24+rB0+2YhPwAwCzCJQDUw2QAA5gTWL7XBBwtafgBgImASgWpgsgEAzAms
XyzZPD/1ET7vdqzB+ggAZQNMIlANTDYAgDkxvfWjDT4SyeZJzPo6hdCr9A0H
qfRAXSwAygjTm0SgHphsAABzYnLrl9Tgg/2Z2PQ8XcuPyJSvu15cHEFPEADK
B5ObRKAmmGwAAHNibutHWwomJ5snkUF9UOlh63Z13o/EEADKCXObRKAqmGwA
AHNiYutHk80tNtfZsPwOVJuwgVVigSzbPt/UmCBPkPQBQBlhYpMI1AaTDQBg
Tsxr/WiDj0zaQbbh4Owld4uF9kOf5h1I+gCgvDCvSQSqg8kGADAnsH5KoNKj
xX1pNt4QpIRJH5OTy8HgciCwzPOxraMj183pXPktchCyhUKluUoAyguYRKAa
mGwAAHMC65czd6d9+2wrSSJhv8tWrKQPIg2IQCBKYWBA0A5WKxmXkmx2u3B8
jyemSiBJAJAAkwhUA5MNAGBOYP1yg0qP+m5fvDgWzUnPN+ljcnJ5dFRQAUQL
lEho5LgRpUOugYiRQABiBACYRKAemGwAAHMC65cbV3lHVZp2hFUO/mouhyCK
w+sVYqJKt7RRlMURcoXkOqFEgDmBSQSqgckGADAnsH55kWvSx/y8sMahc8WR
QYkMDAhrIuQuADAJMIlANTDZAADmBNYvL2g5rLRJH6GQsHzQ2qq9gijWhgUR
YBJgEoFqYLIBAMwJrF8+pEn6KKLooKWraNGq0dFY3arJyVwvkO5PNnI95Ag0
waQoF0YOQq4HqyGgXIFJBKqByQYAMCewfoVDw6vyzh+ned9EIBClQPRCqR17
Wl+LnIvW1ypkNSQQKO2lAqA+MIlANTDZAADmBNavECYnBR8+j5yO1lZBbhDN
oodYJlqAi9xIHosjdruwtqKHuwCgKMAkAtXAZAMAmBNYv/zIY7GDKg6dJ3GT
ayNXSJQIkRVKl0KCQa2vHoCCgUkEqoHJBgAwJ7B+iqBBVoo8c+KW62SNQyk0
jUWRyKJZIQAYF5hEoBqYbAAAcwLrl5lgMNja2kobe6xbZ//TP+UViQ49L3Pk
TqJucO7hWNAgwKDAJALVwGQDAJgTWL8MjI6OUt1BBEhHR4fVahX/N5DB8e7o
KB/RwULuK/eiXtAgwIjAJALVwGQDAJgTWL90zM/PU7kxGvehQ6FQfB3kVyZP
vp6cFHJYckm3hwYBxgImEagGJhsAwJzA+qXjH/8xKKxzDAwkfzMYDIrq44/F
FZAgXewwc+FZoixyWQoh+yAnHRgCmESgGphsAABzAuvHQvxkMdXaSx6O1+uV
/JRL4lvfsvM8HzLPmkcayBPLJSuEPFXTPyqgd2ASgWpgsgEAzAmsXzLz80Kx
2bi3LLP2EQgEODk6OjpGR0fnyzXfIzeIskh6emk3ni/bvBhQBsAkAtXAZAMA
mBNYvwRerzSRobLyK5K8D7vdLqs+KFarlaiVoLljjHLRIHa7qcPVgJ6BSQSq
gckGADAnsH7LosOcpqvFK8k1rzLoDglEpJg8IisXDeJ0YhEE6A6YRKAamGwA
AHMC68cueSRtnmRNUVlZ+eijj2Ze/pBg8oiseAZN2o08eSyCAF0BkwhUA5MN
AGBOzGz90i95xLY//3Ppesfk5OSyUG92cmBgIN7+Izsmj8gi+iJzd3gsggD9
YGaTCFQGkw0AYE5Ma/1GRzO1qyA/8nqXWR3BHGTU6XTmvhRit9u9Xq85I7J4
PssiiFnFGdAXpjWJQH0w2QAA5sSE1i+1sJXMRn5K9iEagQ2jkj0g2ZNoCkUR
WUSzjJqvCV/WxSaiUADQFhOaRKAVmGwAAHNiNus3OZmpO57dvvIGni2u6/F4
Mh88GAzmEZFFo7nMQ+ZVJyJPEIUFNMRsJhFoCCYbAMCcmMr6ZfZ7ibZI9nt5
npeIhRxXK+bn58meSmtkmSoiizznDN0JEYUFNMRUJhFoCyYbAMCcmMf6EXGh
yN1l5YPSRQqiJoiEQURWOjJWG1tmmswDoAbmMYlAczDZAADmxAzWb34+U7pB
uoJLbABV3heAiKx0hEKZAuFS+8wDoAZmMIlAJ2CyAQDMSdlbv8yJHulesLMp
563kKIWBiKx0ZFiWIk8daSBATcreJAL9gMkGADAn5W39iPRIF9tjty9nWFsI
BoMSITBQvBfx+UVkBcq6LR+5uXQjRQSICVaBgF4ob5MIdAUmGwDAnJSx9cuQ
Y561sBKbcu4tQR5CHhFZHo+nXCOyMqxSkXEs05sGuqOMTSLQG5hsAABzUq7W
j0iPDLWtssL2ECxdp3IakdXa2pr7UgjZmaih+bKLScpQCwsCBKhDuZpEoEMw
2QAA5qQsrV8G6ZFjQSk2LKrElywQCoU8Hg8isjJ0RTdNPTCgGWVpEoE+wWQD
AJiT8rN+6aRH7l0k5ufn2bWGEl91CkRQDAwM5K5Byi8iq3D9CEB+lJ9JBLoF
kw0AYE7KzPoNDBQhbodNOXc6naW8anlMHpFFpGK6tB0IEFA6yswkAj2DyQYA
MCflZP3SRewordrKppyT75TsqrNj2oisDCXLIEBAiSgnkwh0DiYbAMCclI31
Sxerk0fDCDbqqXQp54rILyLL0O1CIECAypSNSQT6B5MNAGBOysP6FVF6ENhg
J13FMuUXkUV+RVd3kTvkqtNV4tWHKARlRXmYRGAIMNkAAOakDKxfcaXHsvhM
krHb7cW+5OJAI7JybxfCiT0TjRiRlU6AoAwvKDplYBKBUcBkAwCYE6Nbv2Cw
yNJDJynniiCCgm1QkgGipwwXkQUBAtTB6CYRGAhMNgCAOTG09UuXFJC39CB4
vV6Jr65tynnuzM/Pk4sv44gscpl2u8xwk28a5A6AATC0SQTGApMNAGBOjGv9
iMNZdOmxLJdybrhQpcnJyXKNyCqF3gQgGeOaRGA4MNkAAObEoNYvXRxO4V5o
R0eHxDM3VoRSMmUZkZVOgAwMaH1loCwwqEkERgSTDQBgTgxq/WS7ChYlBUDi
kFvJQQ1O+UVkkVGWTfYxSIgc0DUGNYnAiGCyAQDMiRGtn9dbKukxOTkp8cM7
OjqKccm6QGlEFtlzYGBAJ71OJKQrdGaE8DGga4xoEoFBwWQDAJgTw1m/dEWu
itJ7bnR0VOKBGyXlXBF5RGSR56C3iKx0IlRnlwkMhuFMIjAumGwAAHNiLOuX
LtO8WBLB4/FIHG9D5GLnB1ETXq+XKIvcZUhHR4euIrJkA/CQgQ4KwVgmERga
TDYAgDkxlvXr6ChtujGbcj5pgmYS5B4HBgaMGJGVrviAx6P1lQHDYiyTCAwN
JhsAwJwYyPrxfMlfdLOedtEObQRGR0cNF5GVbjmsfNesQGkx26ceaAgmGwDA
nBjF+smWOSpukH95p5znjuEismRTgZAAAvLDKCYRlAGYbAAAc2II65euyXVx
328HAgGJU+0xdwSPgSKyZNfFTKkdQaEYwiSC8gCTDQBgTgxh/YgIUCG2n+d5
iTs9WpRCWsbHEBFZsjlBXq+alwDKAUOYRFAeYLIBAMyJ/q2fbFxNa2vxT2TO
lPPcySMii2gW1RScbAII4q+AUvRvEkHZgMkGADAnOrd+6WKuSiEL2BCj4p+j
LAgGg3lEZKkg5QIBxF+BQsEHH6gGJhsAwJzo3PrJxlyVIpwmFApJfGZzppzn
zvz8/OjoKLtglAG73e71eksakaXahAHlis5NIignMNkAAOZEz9ZPts5ViTQB
m3I+UMQ+ImUNURM8z+skIkt2scxqRf9BkCt6NomgzMBkAwCYEz1bP7aRXOnC
+NmUcy/emCtEJxFZsolCkJIgR/RsEkGZgckGADAnurV+o6MyPiTPl+p0bE0n
DSrHzvo6LeK5Ld2+2YjsLpEpvoXuU+8Oyu+iMXqIyCJag508xR/P8FmXzaLn
sQB5oFuTCMoPTDYAgDnRp/WTrV9UijpXCdjAoRKeTJ7IrK/bEjv5ZndwQW6X
T/mWNXQPS6dvVvVLVISGEVmqzJ8Zv6shdt1QH2WEPk0iKEsw2QAA5kSf1k82
d7h0axHz8/MSN7i1pFJHnoWgezPH2RwOWxr1EQn7D9m4NQ85HrBwtZ2+m6pf
YZ7kEZHl8XgKjMiSXTsrYq5JJOiu5yw2x0M2LtNaFTAc+jSJoCzBZAMAmBMd
Wr9QSO24feIeSxxgDVLOI5fc9RbOstP1zAOcrLgQ43wsjn3PONakXRzRMXlE
ZBEN6PV65/PNGGf7DxYt/ZwuQtkO+adOiMFyxhsOkA4dmkRQrmCyAQDMiQ6t
Hxu0X+qaRWzKOV+6DJN00KSP+pfPnuiWW9q4O8XvtBAv99IvBZFi5FCfUCjk
8XiURmQFAgGlJ5JNPy/GwNKxWNPCfxqJpepAfZQPOjSJoFzBZAMAmBO9Wb+S
eYyZ0EHKOU36sNS7L87EvriULC/EZHOLzXV2Vgj4MUDSRy4QQTEwMJC7Bskj
IqsUSpYm/lta+KlIfMXKUIFwIDN6M4mgjMFkAwCYE71ZPzZaxm4v+UlbW1sl
jm7e0T75QpM+BCeWJhSkqg8xwVlILphL7Kbu5ZUQGpHFDkEGco/ICoVk0s8L
E7M3fZ21nGUnP3VX+F9MfUjVIjAuejOJoIzBZAMAmBNdWT/ZhY/SdKVLQeLc
2lUQPBJiSR9C8nJEuroRSzYX4nyo61umcT4lisgiWqN4yx90LIRFqHDsO3RE
oD7KB12ZRFDeYLIBAMyJrqyfJgsfbMo58WlLflYJsaQPMZtD/HpFfYgJzrE4
n+TdypfiRmTJVt/Nc/mDNviwHfKHEwNA1UeZxMKBZZ2ZRFDeYLIBAMyJfqyf
VgsfXq9X4s2qnnKeSPoQ35+nSAya4Nzg8s8sx6q8msXRzS8ii/wKG5FVpOWP
pAYfLOUuCc2DfkwiKHsw2QAA5kQ/1o9NEFYnAIp9za56yvlCSjYHjcKi3qzw
sr0qHuezkCbpYzboG3I5Yl0IOYvDdSIYZk9iWPKIyCJjmhyRVZTlj5Uu87mq
jzIfl3JFPyYRlD2YbAAAc6IT6yfb40OFhY9luZRz4u6qceIESUkfqf8Nicnm
8QRn2aSPyJSvuz7h2UamT3TbyrYEExEUbHWyDBDBQmQLHc1Clz9og4+VsVj5
QaxDvbTh4OwlNxEr9Z2vnp0WVOR5tyBDynNcygydmERgBjDZAADmRCfWT6uF
j2Um5dxKvFKVkWZz0KpK3SfOvlwfSzaX3W1ZEpclQtdHuCqXf1HVe1CP+fl5
r9erNCLL5xutrZ3PV94mNfhgfkbD4VJVYXKhAMriNN9W3uNSNujEJAIzgMkG
ADAnerB+soEx6ix8TE5OSjzVjo4ONU68QmrShwBd46i12aqSE5xlkj5ofjpN
SI9R/uojARk7j8dD1GLuMoTjBjguwHEhjuPJ9rWv8Tmtc1Hdl5JsvoKM+pAs
Zgmki5oDukMPJhGYBEw2AIA50YP183plomLUYXR0VOKeqp5yzvqlMQXBySxq
JO9GZUuqQ2vK5ndKI7IUjjhNNk8ei1Ri7c5XnrmMTqTFsqTRWUCP6MEkApOA
yQYAMCd6sH52u9rNzRN4PB6JL5q1f0SRSfueXLKokUunDxoglPYtfXmTe0SW
1WolqjMYDJJ/6dJJ+kGnMVQZ64xlazgYmT77aieRI/XdvinTjYoB0YNJBCYB
kw0AYE40t36yhXZV6zTe0dEhcU3VTjkvFpFp/6udNkF6dPNBM1TkTUuGiKzK
ykryb3JnEBp6V5r+kmG/yxY/8xrHodFpaA8joLlJBOYBkw0AYE40t35svjn5
jmqwDqp65y4as0Gfu1ModWWxdfJB8616pEM2IovN66EKtGRXEQkHR8S6u/JJ
60BvGNMIAEOCyQYAMCfaWr/5eZmFD9W6begg5bxA7k77B+O6w+0z95JHOmhE
VqJdSGtrq2QHGqxVyktAwSsjAYcQqAYmGwDAnGhr/UZHNSu0uyy+G5eoD4/H
o97pC4V2lBB6ffB+BPVkh4jNv/qrv+JSu0mSr8l3tmyRSpJ8uco7qjjO5vIn
9xWkiTxpE0OAroBDCFQDkw0AYE60tX4dHVL14fWqd3ae5yXqY1SdOr9FgCaY
W2zdJyA8cmdkZIQTs87J0BPdQf6l6SFdXcUqNUDVR2pxAFrwypSlAIwIHEKg
GphsAABzoqH1k+1vrmbON5tynpyPrGciU3xL+g4UIB2s3qSis3gVnmPLHHFV
eHfazwtJH5YW9yXExRkDOIRANTDZAADmREPrx7b5cDpVvQC2LJKqp88fWn1X
Fp2F98R6YXAZWl3ElBQnaeNeEuTq8Z6lc69ohZYTxcdiA+Jw/dN7KAVgIIxj
B4DhwWQDAJgTDa1fa6s2/c0poVBI4oYaLeVc/9B+iJQ0nUoin/Ita2J+eoae
GsVgfn5eTq9pUGkN6Bk4hEA1MNkAAOZEK+snW+1KtTYfy3Ip5wNwQIsMDUOy
ORy2NOqD9vJb85DjAWnT9hLAjjjHOTUpdwD0DBxCoBqYbAAAc6KV9WOrXakc
dsWmAHjVzHg3A7E27jtdzzzAyYoLMR3b4tj3jNAOI3Mb9yJA1CWjPrzJM9Ag
ST+gtMAhBKqByQYAMCdaWT+iNTQMu1qWSzkPqtZoxCTQpI/6l8+e6JZb2qBl
uza7L/1SECmlT/pItPxIYjJ5Bhqp3DIoGXAIgWpgsgEAzIlW1s9q1bLa1bKc
L6rq6VUjFIoGg4lNxRPTpA9LvfviTOyLlHR4MdncYnOdnQ2660uf9MGm+fyn
/2SXzECmDyEwI2VrCoD+wGQDAJgTTawf8YK1dfzYBGS2BbbxIEIjEIjwfKSj
c6m1eem3/se0m3Ut2Sfi8US93mip4o1o0oew5BER9IVEfcz4XQ1iIay5xG6l
uYwYXq9XMuIDAwOsBFYz8wjoEziEQDUw2QAA5kQT68fzUq+PfEdNaIdriS+q
6hUUDyIfiI5g5cZsx1fIdsv5tWt8Pd0+89TRb961/oFUjDid0dHRYjrfsaQP
odBuRLq6EUs2b+E/jcSqB5c86cPpdEpGPBAIaB7+B3QIHEKgGphsAABzoon1
Y2vtqpxyUQ4p56FQhOeX7N9OiIjbrV8mEuNy4MFfhR72L//XrFsw2HjV+y0i
T5LFSGTgSHECtGJJH2I2h/j1ivoQq+xaWvipSOpupYTt7TI/P8+WPjCsBgVF
Aw4hUA1MNgCAOdHE+rG1dlWGfRNupJRzojsGjiT0ApEPn4zaA/MtuSiODErk
M0/digxpbY4WtAyQSPoQo61SJAZNNm9w+WeE/VRJ+mCXumigXSgknYeouwvg
EALVwGQDAJgT9a0fm/Shfpc/NuV8Xn8R/16vN3GdHR0dgj5K0h1EKVzj63Nc
5sh9I0JmtuMrMQ1i/3a+6yALKdkcNAqLqg+hym6VzXU2zO4mhQZoFSElxOPx
SIabj4f6EbmhbfUDoDfgEALVwGQDAJgT9a2f5kkfy+JdJ2PX3yvvRHMKojta
W1vp16e+/GdUdxCNUFzRwS6FJDRIpKNTsUeelPSR+t+QmGy+k5+6K+6XPukj
HPT9k8shNEovQkpI4gGyS10DA9LZGAgUeDZgbOAQAtXAZAMAmBP1rV9Hh8ZJ
H2wcjlPlTofZoFdINNFkvCDV6Ogo+c5fVFZe+ce/LjDISpEGWbD/CU1LjyrK
i5Fmc4gqw9J94uzL9bFkc9ndkr6ZoOCUELa+mdVqTfyUTf1A1w+TA4cQqAYm
GwDAnKhv/dgypyrDFl/l1V99yQiNFAqkvoWn33wt8KA60iOxXePrY4sgRKPl
FJ+WmvQhQNc4am22Ks52yB+OfTtj0gc9SBFSQqhwSyc2ibzTPA4Q6Ao4hEA1
MNkAAOZEZevH5vmq32cjEdTExuHoBNqHXfJNIkbINw/wG1RWH2T718mtt1u/
HMtGz94fhM3moN8hxJLN0+yW+SB5wg63pL6Z5jUQgK6AQwhUA5MNAGBOVLZ+
gYD2gS5sFoDeUs6pw6yTtQ+6BeZbbjm/RqOwPjh+PPEMnU6nVLtJkj4EYuoj
VmU3RsZOH/QgxUj6YCsMhFLTWNhQwFI1YARGAA4hUA1MNgCAOVHZ+rEp5+r3
2ciQBaATgr/6FSfmfST8ZLrwscb6h/+iVtJHuiisV37rt+lzIwIk4dgHip6q
XaQ+IJOTk5LhZisMEP2LxHOQAA4hUA1MNgCAOVHZ+rHdpTVPOe/QW6D//PxS
a3N/3MlPrnnlHt2kofQg2z8HG6lek6TDk+8Udf2oaEkfbI6Ph1lsYxPPdZYG
BFQFDiFQDUw2AIA5Udn6sV3OVYbNQdZbynmktZU2Ln/hzf+zzl5DL/L/av0P
xPPXVnqQ7R88NnalQzZOrDCKlvTBtpVkr5NtQKOzEmhAVeAQAtXAZAMAmBOV
rZ/mraXZxnPFjxoqANpMkEgP1crqKtocHfexE4ZGhRVTxBUv6YNjkF2j0bwS
AtAPcAiBamCyAQDMiZrWTw/VTWk5qWRCumluHfV6ifRYsP+JPqUH2ToHvs7q
Ndn6wAVRpKQPKotyibJjO54D0wKHEKgGJhsAwJyoaf3YEBf1C15J3FH9pJxH
JydpH/N/ndyqucpIt9G8j9bW1oRkCwaDVpHi5X0ULemDXedKt0DDlr3SjSQF
agOHEKgGJhsAwJyoaf28Xo3Te9kKSHpJOZ+fX7J/m6iPT0btmkuMXJY/iNxI
Tof/4JVXivcsipb0wZZWnkxTS5cte6WzDjBAPeAQAtXAZAMAmBM1rR9bbldl
H49NOWcrIGlCxOMh0uOW82uai4tctgP8hjXWP6QP8K//erX/t/6HJetXc2uD
rh6hUCj3dS52ZuopGQioChxCoBqYbAAAc6Km9RsY0Fh98Dwv8UiJHlH1CuRI
xFzpNt0j83Zz4Ovk+iP60HEJWKXpTF/Kim2CqbNCaEA94BAC1cBk0yv3bl14
q3/34537n3X1PuU8du7GYlTrSyqIpfGRQz3tTQ6HY7OtqsrlX9T6gmIsjI+8
0Nu5g1zXtobaav1cV3EhT//w/s428vgfaqitd/nDWl+QLlDT+rHR9SrDppyn
C8VRk0hHJ/Her3q/pbmOyG8joolIJ3ILukqWoHWAc1SabEYS1IdpgUMIVAOT
TZcsTLzZaa3Z7r7wRTR684xrcxVn3TUyXUL5sTjpczlsGx5zj4VKdJbozPiH
/tPvuHdZyZzTkfpYnBkf85/xutu/oa/rKi7C0z935p3vt1srOc4G9UExlfqw
Wq0Sj1TtK2CIBoO0zpXmIqKQjUgnYflj4IjWj3MFdqwzFDfTQzU2oBP0YBaA
ScBk0x/Re0G3vaKqcTAoeMJL54+uJx5j5fqj55dKdsqlsb614h+pirbhGyU7
i8Ci31WlRy9fr9dVXMJ+lw3qI4Ga1k/i4KlcbopNBNBDyjld+AjqoJNggRsR
UPpZ/mDLC7Rm6+EB9QEocAiBapTFZFuc5nvKyKGau3jUznFbB8fviP9dCo+f
Hh4+PR4unfggbunPXXWrOG5t89DH90p4Gu28/Gm+LeM5oT5MiIbqQ2UHj+3+
oHnKOV34uN36Zc21Q+HbJ6N2/Sx/eL1epWMN9QEoZeEQAmNQFpONuOuPlJFD
dZV3VHGWbt9sYe2mFBJdmPm3m+GS+94aeflLF49uhPqA+kjFPOqDTTknPqqq
V8BAO5vrv8pujlss+0MHxa/YBJ+szRCtVi0X5oB+KAuHEBiDcphs0d8M2jeW
kUMlqo9y9YO18fLvjA9uzXxOqA8Topr1Iz6ptuqD9UiD2jZ1mJ+npa40Vw3F
2j7z1JE7imqt6ebn5zmGrL+leVIS0Anl4BACg2D8ybZ069R+a1k5VFAfRSZ6
6/291kqoD6gPCapZP7as0MCAOmeOYbfblXqkJSU6Okp8deKxa64airX9KvQw
uaOl1mZtHywbYpdLgg/UB6BobhmAeTD4ZLtz49zLTdUV5eVQQX0UkejijZ+/
2CSk1JtNfUQXQp9cDIyN30q6I6iPFDRUH2oWNWXfh2dNQy41EaeT+Or/OrlV
c9VQxO1265c1zz33eDx5hNhBfQCKwR1CYCSKMdnuzQTf9fQ+2rh5i8PRtL2t
fXf/j8du3GF2I37g2FvuZ/d07XO6eve079rdf9w/PbdS33WlJcGDtqo6wUGK
3r76wQ/6nuvrcz2zp21rU1f/8bHrCVdqKTi0s6G2gl1mlvch79wY+4nbuadr
/9Ou3ifb2/cIJ19IJFYsjI8c6WlvcTi2bbZZHfzV5ejslZHvuVyuLkfjjv73
pwvutRFdmPIfP7J3z95e54EDvft29xzw+IIzksNO845cb0cRmQcofcOLlRYd
ZER28OQphH8zcvSg67ndDvvf9Z+cSr2q6OJM0Od5mpymkfzG9h3kNMnjFSOT
l595jJQjTJFNOU6RpOuKLEz7j7/Y39d38MCeHY1N5DYCqc1WlM2WXIZemPu9
nW10DCrayKOO/+Rz/6Arfq5q2ccWDV9+1/NM52N7eg84e3Z19rq9F0OfX/G+
cvDoa2+//VJb9Td6Tn0e3zdJfUTnpv0/frFP/sNlEkyiPoLBoGT6D6i89CJB
DLsyeqFddqOld7UNvmIXuXLp6gL1AShQH0A1Cp1si9dO9zdXV291vX0p7lAR
X/enrubOoStzSfvdmT79vKOmoWf44zDdizhsx3dbq8WWFnQXSUuCc5MXXjvy
ypmpBfrjxWlfTx1X0Xj0guS1rbhSkPl1rniRNXVPDV+ZjZ08HDzeWVfd9OqF
WCGp5KYPVQ4+OHH8BXfg88XZkz01xHmt7fTdLOAZLYUvDu2qe6DnzcQjIh7p
xKn+lnWNh09OszKN3lGyC1oA2QdIvPdz7w7uYhpepIxIGz8RPH7wtcCtO7On
9tWQXVPy4sXxrV7b6PppcIYWzSJi5NLbrp07JUW00qmP7GOU/yOY5ttyXvv4
+a0LPzr4yum46rl7w7fPyq3edPSjhaR9c54tuQ692Azl7MnBx8Uy/clDPzd9
8cNzp153bq6Wu4Xo4vSJvXU1dXtPxCTP4uQ7e79ZWbWhc3hC2DM00l5Z0zZ8
Lb5/XH3k+uEqc0yiPvSWch4NBIiXfnPg65rrheJu/zq5Vah8lb6reKlh6ypb
c0sgh/oAFKgPoBoFTbbozFj/5grOttuX3Agvem/iZ66m+y07hq/HHa57l49t
qaxc5zw9m/zGNzrBN9dw6549M5vsXlIHaf2eF1468m7KYe/4XfcRn7fTN5ty
EVnVx9zlweZKrt55JqWPXvQa38xckuiCVm17/ntHXrsk+Mxzv3CtI473Rpf/
i9yfSirRxQl+R3XNlsGgtJJt9MapvXUVGw6fm5V418VTH7kOkED6RQk6Ik3P
u196LUgES3TOf3AdmTfrDvpjK1dL4bHnN1VUWnf/7EbyI7736TuuFqulfTj5
nbr8aRSMkXKUqI8nD794+L2Uu7hzznVfhWwJsmyzRfnQ3znTu5qTG/o0t0A/
QZaOkdDKccSHxlU289eEu4gsfDG7sHI7sQ/Xk8/1H87pw1XmmER9OJ1OiVOq
bcp5hOeJl3458KDmeqHom1D5yrpWqwc7Ojqa3yIX1AegQH0A1ShgskXnxvo3
VCT8nAS3x/o2pgS33Lvotq/mKlqGJu6mHiEy6+u2cDXN/ETSAaiDxFVsGZqQ
+Jw0MKneHUxxAzOrD9q5T+5oyzd9nbVc5SP8tRXfUPQnK1bXdLwVc5ijizOf
XEyJnFfI4uWhphpu1VOnbss40JGgu56rtO59/1bKD4ulPnIeIHqlWdTHqppd
P4mrlXsz478en4k/t7kP+zaskjzJ5ZUOhqlDI3MaZWOkHAXqQ26W0uHY7A4u
yP1K+tmSx9DHLiJX9SEehOPsg+PJB4lcctdbZC9Y+YerzDGJ+tBbyjltMvir
0MOai4Wib7ecX9Mw9YOVmUSP5PKLUB+AorlxAOYh/8kWnRresYbjqpt4iSMT
nbvg3lKzvtlzfo7+l74ql3VsRJ+nsn0kyVhTB8lS774k3Z06SFInMrP6+MLv
2ih/tJhHd1/7yGcr36Len8Sdy5/YvadtIC446BWMd10k9ZHrAMXIqj7sg7+R
eyqL14fbK8k9NvHTkh/PfeTeYrU2ey7MZV5iUTZGylGiPmRmadoJlnG25DX0
ytTH0o3hR4WkFgc/LXPByQFXCZR+uMocM6gPNuWciBGVzp2GJevacqq1m7xd
4+uF1I9s/TVKhNVqlYz1fG79R6A+AAXqA6hG/pNNCCkX/pQdvTiXcT/auTtN
UAd1t9b2ja1EjlAHqUpI5pWQh/pYOn90fWW6xA367jr55PRyVvWcup3xlnIm
du/pfTp68RLvukjqI9cBipFNfazrOSX7Qu+zkfb7iIJcf/R8TukZ7GkUjpFy
lKgPqSe/nFV9pJkteQ29QvURGnmiMq36kH2eSj9cZY4Z1Aebcu7ULjGBQvzz
2Y6vaK4UUjfH0c7f47h/1xP8L8yPWkfOfr3BQp7cHz386gMjkUzHuRx4UEj9
UHNlK87k5KRkoHOvbAb1AShQH0A18p5sSxePrudkPSUJ14bbhBzlyob2Z10M
z7Y3VJZSfdwYbhPeDlc1tPemObmM+iieCxa792wuqMS7Lo76yHmAYmRTH5n1
ndx45XgahWOknNKqjzSHzWvoFUZeRaf5pgrJxyc+IpWp6TYxoD5SMIP68Hq9
EqeU18I3ThANBlXr9OELPXzE+60D/Aay/XOwMdPOkb/pqf8drv4//rNEXES2
eQ5VE1nC2dYeCDZlPWMw2CioD49H/QfL1hbw5HwZUB+AAvUBVCPvyRZzlLI7
t9TLyt2vKar6iNWwzbXBQbHVR9Z7l92hOOoj5wFK2V+x+oidpgD1oXCMlKOJ
+shr6BWqj+Vo6JzLXsF95+jFxPILTaJZtaHvQ7kVL6iPFMygPgYGBiROqbYp
51R9XOPrSy093KOb1lhXJd94Z/oqW78I/se/5Ljf6/zPJ5O/H/6bA51/RH7x
9xxf90y35nheQX10dKr/YFtbW/MeaKgPQIH6AKqR92SLXh1qFCzc1sFxtmZs
MqFTPULax+reM5n3i1O4+lgYH3nDPyO+Dr59qkf4+7O+90xORauKrT6+ONO7
PtO9Rz8ZalxNft449ElS6kBx1EfOAxQjT/URu4V0WSE5nEbhGClHxnVfGv/Z
D/yfp+xUZPWR19ArVR9Ea1z8XmPtmsqGZ98Z/2JRqKX8Rk9d7SbnO2k61EB9
pGAG9cE6pTnmApQI2uW81Orjp5NbEws9xAkPBAL0OfyDxya3//aTvrW/x/3e
wz5H4junghsetv0Ox/1uw6FNmaOt9KA+2OweRXMb6gNQoD6AauQ/2TKG6y8L
fQ1u3xZcoHh0etpU7shCeI5px1yI+iBH6In7bzQrIb1vHL0Tvi1991w8F4wW
9eK4xqGrsqePVViVlCcqUt5HrgMUI0/1kTmvZ1n6hOVOo2yMlCPjui/6+9pS
J1ix1UdeQ59WfdwZH9wqJw5mzjzbf+r27emP3ntz8KjLdejosZ+euZKhRBvU
Rwoaqg/Vci8kHqnmKee03G4wcxxUwVvnwNe51LYmxD+nSdn/Mt/C7C9J+mgd
8dXWCkat+vGz236h8NSaqA8iryQDrSi7B+ojK/FYgmrb5m2OGA/aqirkrCb9
k2GpbXgosZtRLCvUB1CNAibbvWv8I8S7tewaCcn4V3euDO6PeVa0D0K6uqmR
jwfbPUmFhpQ6SDTAXqI+9g/foKHwsdJDTNXZ+MmvvNaeVP+n2OojUY1WNgg/
enes/36uovqRN6dLUnE35wESyVd9xBpMSLpOJJA8YdmKu4rGSDmx2lCp6qO/
PbUkVLHVR15DH/3NoH2VzNBH/21k11qZub801rf+6TN3ci/QBvWRgpp/aiXe
HfH3VIBNOe9Q58TpUUd9ODruYwfX4/GQb8okgCQnfawketQezTnaSnP1wcbX
KWoo2doK9ZEb0YXr7zqFYA6ucl3vu9cX0vxdin5x/sVtlVxFVUOX2xv45NZC
cYpolh6oD6AaBU22xXF+Ry1XYXedk7q30ZDvqSeG455VvBtd19tMQMida8PO
J0eSvU6lDhJ9975mx/BUvLfh+FC7+2LCEY533OsauSp1rBYnhrufGbleurWP
ZeHeL7zaVL16g+vn0pZ59OlZ94xI250Xr9tgrgMk7puv+lheXpjg26u5VTL3
GL3ue2r/8DRTVFaaPq1gjPKAJuBXrnRXvDsxtP/F1FJgxVcf+Qz9zJleGxMs
F713+Z++2/ydVTJ5H0St3N/k/vCWfJwVC9RHCmWvPvSWcr6sS/WxkvQR/r97
HL8rPCbL2qOz2/M7tSbqg23pMjk5mfuvSyan1utj+iaWqJg51XFhYujv6nuG
r4QLKJeiBVAfQDUKnGzR8CW+a2NF9VbX25dmYi5QZOHq+/1dh99J8azu3Dj3
MvHE6nreCMa71EUXpvxDT+9+5aNwSsO1T/gdQtflDf2/nEtxqSJzY0c2CH8X
Hh++ntIPLjr95iPVFZWN3zsvfNKJ0vl+97HU7tKLn517sbW64ps9byZd5PS5
oaf2vXLhi6ST3JniH7UQN7Xptcvp3mnkw71bY54d1nWO/vevxg4bXbx1/vWu
b1Zvcr51hXHYw2dddeQq6nvfnSr8jUnuA0Tv3dL+1nWJKxsbkZqmY79Oez3R
L4L8k3UV9zW6fpo0vhOn+vc+/c5kkj8bXZw6vkM4zaP8VKrjnesY5UX06vAj
tVzlthfPC4eKhv1Huocu30vpaE5vn9twZGwuZeijc7/s30B+srZ9eDLVMc9l
tigbekFoXBlqrq7a1O+Pfyiii9PvHXS+eeX0AUEcWR8fPHnW/+H4TOyni9dH
umokbkeVbbOjpX3v80MngzPyQ6ngw1XelL36oP52MgGNWlEk0F/kFU36+N0G
1/1iogflf2v3Z69wpRP1EQqFJKOsNL5Ok8lpVLKrD+KEvPTIUyfSJN/pmrJQ
H1f5tj5TvUaLszjN95Ssek/xKcJki85N+4/3d7VuanhgG3F7ur7r8rw3LiP5
o4szQZ/n6fYtm4XAybZHd3Ud5v1JDnY8sFJwn7Y11FaIXwvvomNx+2Ig5ZbN
tmrx6+R30cSd/sDd01Rn27Rt+9/1vDQq96m/NxN819NLTt64zdHU1v5Yl4v3
TydcsFgP6HhU50MNtRYFdZxyeEbk3k8O9XW1NdGA0aZ2p/utD6clXmvMrHEV
tQ1CaOlmm6KiVelPnnmA4vdOzro1+bGnjgi5ntigpLseIhbIabq3b2rYRB5x
++79rsF3x2eZ4U03iMvZxqiwZ7Aw8YF7r6OurmFb644e9+kV5ZU89FvEcY/f
Y/JwxMaCLg4omi25Df0KS+Hx9zy9j+9of7LX5XruOZfrlQ+IciFPr5rOirbO
3sMj40uJJ/ZGz4b1DYlIZIGH4ndRUd306gU60Pl/uMoZNf/UWq0aBLd0dHRI
/NKQRm24E6iTde4LPUwLXhH9FQwGR0dH6erAAX4DszNN+qAfgv+95+KDB1qE
5Q9p/Ssdqw92hWtgYEDREaA+FJBFfSyFLxzb/fTPjCg9lstDfSydP7rxoCnV
x9zFo48Y6G93OUw2AExI9IsL7u01Dc/6rt5m/s5FFm4GT/9jd11FpbX3tGGM
keqoaf00SeyVOKVWIoG0RrWKu68FHlxj/cPk25cveEWTPlbK6tKlEC5N58Es
W2C+RX314XQ6JQOtaIVLw5IIhiST+jC29FguC4cwOj5oN1kIcQwhEnsj1AcA
oJTQvPWGvrEMpuYLv2sjt+qpU6w6ASLaqo9Sr0Kwza81TzlfjquPm+lbbxRx
+5f5FvfoJtpt8KeTW2X3iSV9tGx4O1FWN6ZHfqfW9cAphWfUpNsgjShLRlFR
ZQ3LQRuStOrD8NJjuQwcwuiNU3vrzJbAKLJ069R+q6HiFgw/2QAwI7SQV/PQ
Vbk6cjHuXR1q5iqfkK1FBpbVtX7EIZX4eKVu+jc6OipxSjVPOacQ/3y24ysq
qI8cNrbTB9la3+b/vbD8Yfn3B6aUlb26HHhQUB8qPme2rFlra6uiI4yOQn0o
QV59EOnheeypEUNLj2WjO4Q0e5QzXfmUeGJ1hbGipo092QAwK9HQO101yfnp
zA5hf/+mqpqud+TqLQMBNa0f8egkPl6p87/ZlHOiR0p7ytxYsn71rvUPtNYd
dJN0+ohvs//5YSF36nf+0v03ivp9XOPrifqIqthNnh1lpRqTnZkqXr4BkVEf
YnnD+3t8xn/PUwSTuBgK+jy9j24V0jcdrW3te/qPB27IiLI7N8Z+4nbu6dr/
tKv3yXZhN39yOuTS+Mjh3s42mgArqgkhefPYkef6nnMdeLKtsaWr/8djNxL5
mwvBoSfiCY8SVhxycsxDPe1N9JhC2uNS+MqJo66Dz3U12Xc8f1JSgpImzO7d
09P7tOuAc//uHqfn3URRHTlo4uqjjZu3OBxN29vad6dc4cpxF2+MveV+dk/X
Pqerd0/7rt3CnSfltwp3vr9TSBR90FZVJ1x89PbVD37Q91xfn+uZPW1bm7r6
j4+tlAFdCg7tjKdySpARYYvXybmde57c73y2d89j7cK5k6sbLYyPHOlpb3E4
tm22WYUZHp29MvI9l8vV5Wjc0f9+ccU11AcAxmQpHBx2Nm5odL5+bmI2xcgs
zk6ce1380XDQaCUf1URN66f+G2Y25VxRFdbSEenoJC76r0IPay09Ujt9pPzo
v/yz+98Jj0xh6d3Zjq+QWyt5UF0SbC/7oELxMDAA9aEEqfqgldWJ91e7gx83
+hv3wkxidHH6g35HbXWj6+1gKPYoiBh5+2Dzzh9eSS4yuXjtdH9zTd1Tw/HC
j9Fw8Hhn3UqZFKEM//iH/tPvuHdZRTf63K2PXjt47EzMSycO/Ds91sqKTS9d
kBTizFg6PuWYjtcnJt466PbfWvz8VM96LrVjcjR8fmhXw4akGq2CBDh1xLFu
m+vklMyxxTuqTikuSsTIT13NnUNXkmv735k+/byjpqFn+OPYa0Pi3h/fba3e
7k7U9hSu8tyZd77fbq0UpNO5yQuvHXnlTFwjLE77euq4isajFyRrHGlbAyTu
SRyd++tWCkET8XW802ptcicKzy7OjI/5z3jd7d8QZ3hw4vgL7sDni7Mne2oq
MrSuzg+oDwAMDBEa/pFjL/T27HX19R10uQ729bn29vS+cGzEL5EkgEFN68dG
1yusS6QYNh2gtOfLGVp095NRu+bqY6XTB/ujqQ125csfd61/sGT9qmpPcn5+
XjLEeRQWYDOSlGSNmI8U9SEEXD3ySO+B7bXC96ofS2luZUAKsRLiavtqzrrX
dyP5L8/CxDuHm6y1Kx3ZlucuDzZXcvXOMynL8mLb4sp1ztMplehjXbU6XnC/
8m7KYWf9rg0y/nAujavoMbcdch95PShoIjFBkqtc5/pFTCeIDbkqtxxLLcu/
HMutYBuoxRuW7fYlt1CL3pv4mavpfstKo7HovcvHtrD3GJ3gm2u4dc+emU1+
VUhLa67f88JLR95NOewdv+u+VK0kkk193AsObqlmzkJ7UkvHQnxCVdue/96R
1y4JE5p2DOc2uvxfyB88L/TzJwkAANRETetHPDo165qyPSD0kHJO+bXXu/+3
fpte1f/jtMo0H1dpk036SGzxSry2df9fOKflj3+d3CokfahYMYpN7XEqP7sm
taANzIr6+ESUHp4L4aXFiR82Ee+Mq6h57O3rRo50LcAkzo71PVDB1TTzEykP
YGmsb21FkiCI3gu67RVcxZahCemDuunrrOUqH+GvMe2JuaotQ+OS5lVirXhL
vftSSvH63NXH6vt3vRUXRIu3xi9+El+zWJgYaqvk1vWcklvBjFxy11s46/5T
t1YaWs+N9W+o4Cqb+Wspl3h7rG9jSvzTvYtu+2quomVoQtJUKzLr67ZIH12s
sL/Mg6L3WO8Optx5ZvUxF3Q/VCHzGMm4+Tot0osXn1DF6pqOt2IRXtHFmU8u
jt8q7vtMqA8AgDlR2fpJfLySlr8NBAISv9SjbiGmdCQcZrsI/do9uknzdZDC
t1jSh4rJNQMDA5JRTm6wmAsqi+JyIKY+Vn2zYzeVHuJ36ft8wrrHRq4ZV3/k
bRKj14d3kPuv2MG0A5u94G6usZInRV/V04UGRjUIUEFxX/vIZ0nfo+pjszu4
ILczozNyVx/c1sFxNikj/p6/4tHhG7JBy1RTJCmF6NTwjjUcV90kkV1ElVxw
b6lZ3+w5P0f/6z+4TkY1rFx2ZftIkuCh6kPuQcnfY0b1EVu8YB9j/BdTq9PE
npB9kNEqxQTqAwBgTlS2fmqGuPA8L/FL9ZByHgqFrCKJhhTBYJBGiPn0kAZS
2Ha79csqJ30k5FsCpd0k1Q8INDwx9VGRnKQgQN9sE1JejBuMfE3iUmjkCUF8
rT96MfOtL50/ur4yXQYBfeW+tm+M8YPZHscFq480teiXLh5dn+kIsfOuKIXQ
SLtw5/ajF+dkfyHO3MWjwqeViZhKuqSUO6fqQ66tjHL1EbspS7dvllU+9EQb
+8ZuSy5nVc+p28zeRQTqAwBgTlS2fmqm97Ip50qTkUsB7cotKcpEhdIR77c0
lw+FbLGwK4XVbguB7edCxIjSg3i9KLerkLT9PqILF17aJAQZVVr3vn/LmOsf
+ZrEmGvNCYWkMnJjuE2Mw2po73UxPNveUKma+pDfh5ayz64+Ekoh5tjLXKGE
a8NtNcLkaGh/Ns2dl0x9xG9K/ty97Q1Vsuqj1HWLoT4AAOZEZevHljYtnaen
z5RzKjQkOoh2rDjAb9BcQRSyfeapUznsikq5ZPIIrkPBK8Vk6nUevnC0Uax9
Kk3jNQr5GopYkkJ29RF7ejm3pVBbfcTFRVb1Ed8hdoHZ1QdVB7m79EVUH1lv
ivkFqA8AACgZKls/NsqlRAnKbCkkpR3oSgRVH5IYMJoJYmj1EZhvEatdrVWz
XJTT6ZSMckB5CxkyL1DwShmZ1MdydPbnrg2ryI8rNhw+N2u8+Kt8TaLY2ZbL
IVPg9qke4fGs7z2TW/WkwtXH0vjID/wz7DHlfevonTPO1eQIq51n7sjeSfxO
G4eu0uK/V4cahf+nySJZIXSqR0j7WN17JvN+cQpXHwvjI2/4Z5aEYsGnnlqV
6aakQH0AAEDpUNn6sRm+yiNlcoLtfz2gj2h+WonLarUmOo+QL+gyzU8nt2ou
IvLernq/JYRdDRxR82FyDPPKlYOalRDKhIzqgzi7s2eeFbxMbtWGvg8zZwLo
kLxNYsbMAkJkITwnurKfjbTfRx6OffA38n5w9E74dpLPW7j6IEdoS12Ryexb
izWgOK556Kps8eQvzvSuT0kGz5jJItzQwu3bQjWteGpMWoGWeESUwtUHOUJP
7LnFklPSSqT4RcaA+gAAgNKhvvUjckOFV81syrnSUkilI9Gb2ylCv/4Hj01z
BVHIwseC/U9Uzjdna5rlUVFZtcW4siKL+iCe3I1Te+uEXWRawumd/E0ibVrB
rd018m8yznXk48F2j1jrKVb6ialPG9/xymvtyVWelKoPmlciUR/twzdSfjWz
b01LB69JalCSxN1A3/2VqY1daMsMzrJrRC7Y7s6Vwf2xSlO08JSkpPDKnSce
EUWp+qB5JRL1sT9euYuWGmPqIbMXKQL1AQAApUN968eG2SsPlskOG5Ojh5Tz
BEQKJdJS/qKycuhrX9JcQRSy0UK7Ki98JERcAl55EpGaiUjlQ1b1IZaffcQi
6g+2Gbe+KcAkRhcn+B3VFXIhZ0sh34Enhq8mennT3nxdI1elzu3ixHD3MyPX
C1j7oCsRle3D8YNEJ37U/uL5lAvK5ltHwx+5m9bK3cjCBN9ezV652J2QY7sQ
kkOFfE89MRxvFrgUHnt+U0Wltevt6UXJjneuDTufTKnVrFR90MT/JNEUHR9q
dydKkMV7Qe4ZmZYsf0QXr73V/eTIdWm/D6gP47M0PnKop73J4XA8aKuqyzXZ
qnQsfn5h+MjuXV37Dxzo7TlwzP+ZXOGH8ZHD+zvbyEU/1FBbX4JrXhgfOdLT
3uJwbNtsq85gBhZvnR/u37Or87sHXL09zh/4b+QWMlnWrEyozbaqUhuIskZ9
68eWGCpFFw62EGvxz1EwIZFIRydx3YkDr7mIyHvhQ8j4UHfhY1nI12iVDHEi
mC13nE6knCskunD9XacYWFW5rvfd6wtpoow+/acdFjosq+p6fnzxpmEUSGG2
Yikc5LvqVlc3ut4OhuLe/+2rp17sevpnKf724mfnXmytrvhmz5uX4j3+IgvT
54ae2vfKhS+S+3ovTh0Xn+QD/WMp7cGXo7Nj/Q+QH1ja37qe4snfmx5+rJqr
bnxxLBwVlc6Rp49dTo6Aix+zcvuxy3Ild+k+t37p2fGNGseRU1fj+xDH6fUn
66of7H3r4zDza9HwJb5rY0X1VtfbSXd09f3+rsPvpHj7d26ce7mpenVdzxvB
mdgKSHRhyj/09O5XPko57OIn/A6hpfmG/l/OpZwuMjd2ZINw548PX0/pWhid
fvOR6orKxu+dFwpBE6Xz/e5jwaRVlujijZ+/SFRV3VNvrozO3LR/6Kndx1Jq
Ry/fmeIfFZ5Q02uX5Wd4cdDnHya9szjpczlsGx5zj+VQ1yI6M/7huTPvfL/d
Wqmg1EOJWPzkzV22GrFQefTWademGq66c+QG47+W/JoXZ8bH/Ge87vZvyIj4
+EUsTryxy7quyU0+lUu3zhzeVFVZvevtG6W143emfQcbbZva3R/O6PUPhjA4
/tPvuHdZ0z87kAvqWz/iIUr8vaKng7Mp53kUYlWPUIi47sSB/5Ux+33ccn5N
WPhQd82AbWRvzSthA13Ocyde2shS2/CQg7KtoVasb5Vqg2Oljbgq22YHfeUo
7pS9JpIuKNwkCr708f6u7d9p2PSQo+nRrv2HPO9eZt11IhNmgu96etu3bG7c
5mhqa3+sy8X7p1cc7fgDr6iyPZh40uJCQPwJV9Q2bIs/3uQxIHrng1d7HBtt
DVu379j70ulri3LHXBnAdHW6FkPBkz/s69oRG+6mXb3unyRfIXPnxJMnd966
qeGBbY6W9q7vujzvjYfZygPRxZmgz/M0ufPN2xyOtkd3dR3m/VMLzJ0LUyh+
5+JFxktXCZNwy2Zbtfh1sntG9M4H7p6mOtumbdv/ruelUWaFRbwpH3nq2zZv
3krO3b6rW3jqKxIjXruMq7YJF/dQQ60l8zJfIUB95MHSWN9acYQq2lLjCTNB
k5W0VR9zQfdDFRVNg1eEAL94neoMXXLoVCzhNWda4BObN1U0HrsifILi5cSz
NjMqEGFoxU972lanukGdxdGyRhPrx7p8xU39YFPOnfqO5ieuO3HgZzu+ormU
ULpdDjxIrnzJ/m2VC0Ul+sUXMsQqCGFgOOAQAtUoi8lGJGGPql59+OeuulUc
t7Z56GPZsgiyv1NqTz47NCQyUXIhOjv+wU+GP7gi916CoqX6EMXRSmWMaPjK
B8M/+WB8NuOKxFW+ra8wb/zWOdemCq6iunnoyj29Ln5QoD4KRhPrx4a7FDf1
g005zyMjQGWWWpuJG3/VUA0HfxV6mMZcRVUPVxoYGJAMcR6N7Nmkj1IEAQJj
URYOITAGZTHZ5i4efURlrz66MPNvN8NK/D4dqA8xWcnS6ZvN9Rc0VB90kTFt
FTt5iLzaeLBQb1wY2s/D7JKl3oD6KBhNrB+b+lHcarisa1q0lPNYLcoMdTWX
I1N8C92n3h3MOWQ4Ojm5ZF1LPPl/NU7d3dutXxZirrRw2dlWkiHlWScdHWoU
QADGoiwcQmAMymGyRX8zaN+ofTZ3FvSiPpS4q5qrD2Wnjo4P2s3jjUN9FIwm
1o+NeCluWgabj5xHGwg5IrO+7lgqLbc5uTxj0i6f8i1r6B5K3nIIREdHDZQA
cnPg60LMVWtzMR6sMiYnJyXjm0crSbb1TBk4AqBwysEhBAbB+JNt6dap/VbN
s7mzA/UhQzHVB62ybh5vHOqjYLSyfmzXD+X1itIicU2Ll3K+EHRvJh9Jh8OW
Rn1Ewv5DNm7NQ44HLEpXLenvDxwhLv3t1i8H5ls01xcZts88dZqke1C8Xq9k
iD3K119GR9HpA8hgfIcQGAaDTzZavqxC62zuXID6kKFo6oNW8OPK1RuPLNz6
9KL/o/GZpDQjqI+C0cr6sV0/ipWZUcKU88gld72Fs+x0PfOAfEhk+KzLZrE4
9j3jWJN2cSTrSXQvQD4ZtQvSw7o2WkTFqISOjg7JEAeUh0yxM1A37SiBlhjc
IQRGohiTjVZOe7Rx8xaHo2l7W/vu/h+PyfRliC7eGHvL/eyern1OV++e9l27
+4+nlC9b6TER74shVE77Qd9zfX2uZ/a0bW3q6j8+ttKHZik4tDNejUzCikeW
0mtjBz+9GA3/ZuToQddzux32v+s/OZXquEUWhIpp393Ts9/perZ3/54ep8eX
KIwcY2F85IXezh20XFu1vOsnPJBB197Ozp5eF+HQ0R+eubowm8aTv3Nj7KeD
7sEfDQ+/yb8x/OaQ+5U3Tr/vfqTrJ7lV08rlmhOF2iRk9e2T1IdQTe7HL/bJ
jwVzR2+86BJx7uvs6Okb+kCu7px4ZTIedLyeXtpBlbAQHHpCrAuX6QZTemQI
xeuWwldOHHUdfK6ryb7j+ZNiRW5hAvZ2tmUY2sXrY8dfFm/sgHP/7o7dfUOn
2Jz9xAxJtDIR6uAdE+bxwQN7djQ2kYkfuCGfV7IUHn/P09v1WE/vAeeeXR1P
u0cuhmY+9rr7jx576+3vP1Jds+9UIt4+k/rI9llL7DP4yuCPyKw7/ubwj4fc
nuOn3/E8su8tnRf7Kh5a/akl3mKJyg2xL8aLlnJOkz7qXz57oltuaePuFL/T
QkTHpV8KIkVJ0kcK8/OR1lbdChDaWFBD6cGWU85vDrOF19RtVwJ0CtQHUI1C
J9vitdP9zdUpPVaI7/1TV3Pn0JXkOq53pk8/76hp6BmON2qJzl45vttavd2d
aC4j6TFxbvLCa0deORMvg7w47eup4yoaj16QOMzUWU3jSKccs42fCB4/+Frg
1p3ZU/tquNTcyegXF4c66jYk9WGhzWIc9Y2u95LKJouNKs69O7grTaOKxamT
rq01to5/HPt85TgTI0/v7n+hYx1znQsTbz655akTyWWZo+GLx9pq09agTrm7
HK85Dm2RmcuRY8TVR65jQZi78kOnc6WFUHTx1odC29C6/e9IO2yKR8qy9qGk
0LR8A9AYKT0yHK9PTLx10O2/tfj5qR6h6jCNURf3OXty8HH5Phr3Pv5htyvp
Ud+7NeYW2gbtPZH6qCWtTH5+68KPDr5yOl5S++4N3z4rt3rT0Y+YV8N3pt/Z
X1f5zb3vTIqniC5On9hbV1W1rnv42h2hXezIE5XJdYDTPrscPmtiL5XHtjyd
MijR2eCxndUGqUtfFDT8U1si949NOc/jxbgcNOnDUu++OBP74lKyvBCTzS02
19nZoLteedJHCkSAiC0IiQDRVRJ6LNdDO+mxLOjWgGR8Ozo6lB8EtXaBPFAf
QDUKmmzRmbH+zRWcbbdvOsn9it6b+Jmr6X7LjuF46/bovcvHtlRWrnOeTqmX
Gp3gm2u4dc+eSWlnTz3e9XteeOnIuymHveN33Sfzdy2j+kg5ZtPz7pdeC84J
XWH8B4V2pesO+mPvgxcm+PbqyubBy9LOF9Fb7++1Vm1w/VxS6VXe9YvePO1s
qKh0uH8tuZjo4rXhXTVMhNjsyZ6abYPjUrc8Qv6CZ9cIiq85X/Wx/snn+g/n
NBbL0evDO2rqHHuPB5OauwrfrOQq7O4gU8NWNfWRcr5th9xHXhcv5gu/a6PQ
tdb1iznJPtLjLF4nA2hr2sv/eiHlm+2V3Gq7+yJbeDl2mD1H3EfeS+mQeOec
674KtmpQ9BrfXMlZdo0kNbC8d41/pJKraeYnhO9FF774IumxppmCuX3WiOza
kKhmvIIQXbMT6kMF2Lq7RQl9YcNy8qiGJAdN+hCWPATrJFUfM35Xgzil5xK7
FXg+GoJ11/oHlwMPqqwyXgs8eIDfcMT7LV88/z0w3zLb8RVRenxVQ+lB8Hg8
kvH1Kp83bNgVau0CCtQHUI0CJlt0bqx/QwVX2cxfS3Fibo/1bUwJlRHbxnEV
LUMTd1OPQN+nxZ2rGLFmixVbhiZknWfpmn7u6mNVza6fxAXRvZnxX8ej6KOL
Ez9squRW9Zy6LfO79M9u3d5TKS6knOu3FPLtqeEq1vSeluve99lI+32S6xQP
8p2jF5nTLo31PXo8o0bI55rzVR+5j0WiS+fGvrHk66L3Lvnmyv5qq4/V9+96
ayp2Q4u3xi9+MpO8eCF/TfEeoGv7xpK1cmiEyA/pN5MOIzft6YyVBMbTIVsl
UQSip5emeKnsdeb4WRN+17Lh6HlGNJEP73ehPlSATfstSna4xDXNrwW2DLGk
D0EyR6SrG7Fk8xb+08jyTV9nbd5JH9Jzil0IyfaZp04d3fHTya02+58mP8B/
8NiCwUba10OocKVFmnkydrtdMsSTCtUQuQN23U1TRQV0BNQHUI38J1t0anjH
Go6rbuIlnml07oJ7S836Zs/5OfpfutAg60GJHmNl+0jS6znq5klX9hM7M26h
AvUh87JXgL4Ar2kbvib7y7SzuURkybh+0fGhLeR763pOyb5slMngjk4Mbang
Kuq6h/xTCylXNvvx2KcZ/37nc835qo/cx2J5ee68p9m2rtlzISXJgB5H5mq1
UR/cVna9Kds1kVntaV5ni8/q1J3lGqPHTiUz7WVn7LXhthqZ+6U3Jdt4XW4K
5vpZo3O1YmPX0Ll4SBglEv74wviC3KekHNH2T23RnUC2FmseYTnyxJI+xHkl
fr2iPsQqu5YWfiqSulsxiAYCtA+IClFY/zLfssb6h5yYpx8IBEZHR6mr/8pv
/bbQ12PgiObSIxQKFa4uSyR7QXkA9QFUI//JRt/6cvajF+Xe9K8wd/GoYMPl
I4GpB5Xy6ph6qnJuZ6HqI40uoB3AMxyBnrfyiZHQylXKuH43htsqMni2cvWj
otO+3eIbda6iyralfe+RwTff9Y/fyv7qOa9rzld95D4Wio+jjfpY9dSp2+kd
bEW1pGIaQyZXIvYTmactO2Pp8lAa9SHb3E3mOnP/rC3e8O2NdSyrsjW273th
8A2ff3xG/z0Wi4q2f2rZAJgC2w4Sh1ninRYp5TyR9CG+hUiRGDTZvMHln1mO
L9UVlPTBEgrRNBC6CFK6VPQD/AYutXrt/Pw87ev3+fvvF/GG8oYd3wHlM4Zt
MohqVyAB1AdQjbwn29LFo0K+bvYcVfpSl6tsaH/WxfBse4M0cKV06iPNPjHV
kM2TTw0cYl2/eNBRugeS5hoWp072tVpTSndV1+169ZxM0bBCr1lF9XFvZtzv
493P9XR19R7q63u6vaFKR+qjkH0Wb4l3drins7v3ub6+A+IELoL6IPe7o4Kr
kMRw0U9Z5UoKVebrVPRZuzN9sr/JmlwrrKKq7nH3uc/MEnel9Z9aNvm3wDgp
NimgSCnnCynZHDQKi6oPocpulc11NszuliAc9P2TyxGfaBbHoRNBxepE6EVo
/SrNBLnG15dCgzg6iPyXdmYk8o0rYrP4wnA6nZLxJXpE0RFCIZkmg6h2BRJA
fQDVyHuyZXO2E8QKqObcl0B19RFz1LN68mzKRjHUh0Bk4eZv/L43Bl/Y195o
o9VmKxtf+XWGAJi8rlkV9bEUvuJ9run+SusjL4yMXQ0vZj6OkdRHdPbKyHNN
1ipr2/PinUVXdi6C+iCH/7lrwypuw4sXV3Lz54LuhyoqHugbk/PWZK5T6Wdt
Obpw42P/u28OHtnbvsVWJWpgmZoJZYvmf2rZtoMK3ckU2JRzpUkB8iQlfaT+
NyQmm+/kp2iSkVzSR/i827GGs3W+6p+OLEfCl14VZIjsWl5W5ucjPL9ovY9q
kJsDXy9uV/SHH/sPOlcfdCEmGaVd7HleOt+KFZoHygPNTSIwD3lPtujVoUbB
/mUMoRcIneoRQtFX957JvF+cwtXHwvjIG/4Zto5WGl/9zpne1eS463vPfCF7
QfE7bR66upKkW5TIq+jNix9elaR30JK5a7PUjcnrmkuvPpZm/UfsVRUVm/rP
3UpOaNZIfSyNj/xAjAjJ4XxZ9omG/P1bqrjVm/p+fotNUS+G+lhevn3xxaba
tTUNzhPjRLUthoJvPlVX/aDTNyl/sTLXmfNnLXrjow8nJSnn0YWJU/3N1UWP
nNExmv+p9XiK6Q1yDMW5Smk2h6gyLN0nzr5cH0s2l91tOV4LKyFPlnN7WZSR
UEjIRheTQWg+yFXvtwqRIYH5lsuBB4mWcf/J/8yllpAivj1N/ShS3bCCYJN6
WpXXyWVTjQpRu6D80NwkAvOQ/2SLpR6kdZKjC7dvC36a2KeAnMY+OC7/Lj+y
EJ5L8q8KVx/kCD2p3mDmnt30ld3qxqFP5C4weueMU/D0U1MpZVy/yMeDD6xW
lHW+6D/0AJvQLbi673TVVGT0kfO55pKrj7lfuNaRod7o8ks0UcpxItO/fC8e
elFa9UGO3pZ6s3mqD7ZEc+rOMfVxd9p/JhiOpPwkd/Uxd/rZZz64vTD90btv
DB495HIdPfb2z6/MsKV8M1xnzp818rsPyKUGR6/7uu43T/90zf/UykbC5Lde
waYkFynlPDXpQ4Aan1qbrYqzHfLHJzyb9CGTBiJZRsmb+XkhFqu1mWoQsi3Y
/4QoiE9G7cFgY1bFQdQKURzX+PpYHV1xu7H2z//iz/6ME5NlyMMMBAJ0Lalo
zeILg67CJONRWCeXzTcvVkU0UDZobhKBeShgstFmBJIOBQnuXBncH1uCp05p
5SP8NTlXijjt7Z4kR0ip+qCx7hL1sT+1RlBm9REvHSwbXb8cHutrIH9qHxm+
mq3i7r3p4cequcr7+wJ3maMIDReaqtnwreoHBq/I/B0mDuoamUpThV1zqdUH
LbTFrXaeuSO5JuquxI6z6O9rix+wmOqDrj1J1Ef7cErL+DzVR6yItMyaAn3f
G1MfKbJXqfogT299ruuD6e8lx8+aMPO2DV5hzyY+9uLVLNI5evhTy2YB55d7
zvahU+qdpoHN5qDfIcSSzTPulvwdWpu3qItroVDU602kpSe2u9Y/IMqC3W63
flmy55L925GBI1ExQWZ0dFQS3dTa2qo0uqlEkCuRjK/SeDB2pqHNB5CgB5MI
TEJBk21xnN9Ry1XYXeek+iMa8j31xHC8Qd1SeOz5TRWV1q63mQbcd64NO58c
Sa4Lq1R90Do/a3YMxzs4RMeH2t0XUwqUZlYfQtPwC+7t1TI3El2c4HdUW9gr
T9OSbmJ41zquup2fkMRTLc2eO7yByRMXD8J05SDcDfTdb+8byxicoPyaS60+
Ys0p2D5610d6H7BVrqiP5ztHPqM/Kqb6oItxle3D12MHi078qP3F8ykTIU/1
EXO3GK9p8fpPnA9srFpRHwefTRQZU5z3MT5or97uHvs812UH+XvJ7bMm/G6l
de/7t6Qzj+hWu7x8Lkf08KeWzT0nWx4OL/tuXGlKsjwyqxXxjwOtshsja6eP
u9P+wU6bhbPt802XZH5Fg8EIzxMpIYgRMUVddiM/FTaeFxQHE1IVCoW8Xq/T
6STarTgPsBgQBcQxKDoCUSrINwdZ0YNJBCahwMkWDV/iuzZWVG91vX0pXq5T
zFzoOvzOdPKb1Ts3zr3cVL26rueNYDyYJLow5R96evcrH4VTFhU+4XcIbbQ3
9P8yNcglMjd2RCiJaHl8+HrKH6/o9JuPVFdUNn7vfHhJ9L6+330smPLmN3bM
mqZj6TO5Fz8f8zxqrWnuPzUR3+ferQuvd9XVbur9yZWwpNvCnSn+USF7sv2t
66k+XjR8fmjXhsq6745MxIu6Ruemz7h3P/366/u/wXGV1vbvv3Pm3IfjM9GY
/1j9jU1PpPici5/9or/tO/2/kHYqL/Sal8L+w3XkAa5zvns9t44OSseCtnrn
Vm1wvhd/LNHFG2dfOchfuvx6c2VFza7ha/dmL7x04IexXnjxx7jj+JTEVY7e
8rs2CV3Ie8nF5vginq49VTe+OCbMqOjM2JGnj6U0go8uTh3fQc5Xuf3Y5XQl
d+P7pN5a9NYHzrpVXMUm58lESB+Z0q8d/OHYZWEFcN2u4Yl7cx+99OTr8eY3
sVvjNhwZm0vVYnO/7N9AfrK2fTg1oSN6beSxdan+RUWV7UFHU/veF350MhhK
VSWJ63yUn5IsYeTwWRNmXkXVN76zy/1hUhrLnRu/eKHpO0f8s0xvkTJFJ39q
2dzzPArllirlvHDi9TgELI5DZ6fLZGEttu6ZKYk+MsW30H0KW09kF7aUxoOR
3ZFvDrKiE5MIzEARJhvxrv3H+7taNzU8sM3R0t71XZfnvXGp6yvstzgT9Hme
bt+yefM2h6Pt0V1dh/nkLnuJP1JVts3bGmppEVrh1TF9DS5Y+dqGLZtt1eLX
ya+Oid75wN3TVGfbtG373/W8NLry1jf5mA6HI3bYdGWp7s0ETw71dbc5KC3t
ve63pH0A4z2vK2obtiZfZPKNzo6f+mHf7o7O/U+LpU77B9+9HI6SX6yvbXjI
4Whq69x/eGRcUEpj3293fxS+d33s+MuJuqi9ziNDp66Ec5IHOV5z8gMkF7At
9gwzLILkPRbCZPjx0b3tTU3tPQcO9vU913fsg6uCfKD1XVdV1e3sPzm1mPwY
tz0Yq7YUe40fK9wk/ojcEf1pbosg0dtXP3i1x7HR1rB1+469L52+xlQkE/35
xERIfQLxfcitbW6opU7DylQRHPjj5M5ahDtzPdf33JFjH4iiL1Yzubpux/Mn
BcUdvzWu2rZ5S8pxYoXIxDvbHCtutrJ2IaaZb7CKN50g8fC5tU3umHZIuk7Z
j8Ny9s/a0tiL7Z4L4bkbY2+8GJ95B3qf6R/6QO6TW7bo5E+t1ysTkK90+YMt
iFSai82b2eCJQ2LBq+QkdONC02EoaVZ8xD6MMdVVWLDZwMCAZHC9Srp0yKYX
6aOOF9AX+rMboGzBZANAc6Lhj9xN6xucP7vKLvREF24GR/+xa2MFt6H3DEIl
iolOrB8RGmwxIkXLH2zKeR4FkUpPwQWvdAQNP7M5HLY06oMmuax5yPGAJXMB
wxygpbeSUbSwxfa1RH9zIItOTCIwA5hsAGiNWCXg/v6xu+lXvMR08lU9p26n
3QMoRj/Wj23EoGj5IxgMSrzTPLpgFxPZHD2aQpIpN8Q4xNJhdrqeeUC+8KPQ
h9Ficex7xrGmwFtmpaVdiXiQXfjQTUYL0Bf6MYmg7MFkA0BrxLptjUNXM4Tb
RT8Zalxd2T6CxY8ioh/rV+DyB5tyrigyp/hQ9ZGS7EDXAizxxugGJ9bc5OWz
J7rlljbuTvE7LUR0XPrlSl/4fCFDWYi0xMIHyB39mERQ9mCyAaA1SyHfnpqK
zf1jM2n0B61kdX+XT66+MsgXXVk/1kvMffnD6XRKHFSN23PHljnqu31iWazI
tJ93OSycxfHqpXAZJJ0neqBcnJE2QxF/LCSbCzprlu14ohx2cANifeBcwMIH
UISuTCIobzDZANCe6BfB4Wca12118r+YCKc0WV8MT5zjnxZ+NHwp51oEICd0
Zf1kHcUclz/YvIASX2x2ItNnX+2sT1yPxeH6J1+wHFY9BFZamYhlxiXqg3Z4
7/bNzjEdT/KBrSeQewsStscHFj5ABvRgOoBJwGQDQB8IQsM/8toLT/XsPdzX
J5Sheq7v8Hd7njpybMSfKklAcdCb9ZPN/sjalIFtBqHLlPMyIqkHCtPPPZZs
3sJ/GsneAyU7bEZP7oMr2+MDCx8gA3oziaCMwWQDAJgTvVk/2eyPrDH+rIOq
tBkEUEYs6UPM5hC/XlEfYpXdWB/G5N3yxePxSAaXzzkdCAsfQCl6M4mgjMFk
AwCYEx1aP3b5I2trBjblPHcHFSgnkfQhRlulSAyabN7g8s8I+xUj6aO1tVUy
uDlm9IyOYuEDKEaHJhGUK5hsAABzokPrJ7v8kTnWhm1Fp3HKeZmzkJLNQaOw
qPoQquxWxYt6LRSe9MHG1FnJ5MjpF2VmEZqbg6zo0CSCcgWTDQBgTvRp/WTf
WmcooMu+Hs89KxkoJinpI/W/ITHZPNHJPWvSRyR86VWHJdPiyOjoaH4xdR6P
4hU0AJb1ahJBWYLJBgAwJ7q1fq2tCqrvShxURa3ogGKk2RyiyrB0nzj7cn0s
2Vx2Nwkx6ZF5cYRd1cqljcvkpIz00Lb5JDAKujWJoPzAZAMAmBPdWj/ZakWy
r72Rcq4uqUkfAnSNo9Zmq+Jsh/zxbiaZkz4i0ye6bRZxuDJVxGILKYeyVkBL
I11z+D0A9GsSQfmByQYAMCd6tn5s80GysV3m2EbYSDkvJWw2B/0OIZZsnma3
FUTpUWXrfaazKlNFrMnJyTxWtWSrFmBGgBzRs0kEZQYmGwDAnOjZ+skmDrPx
V2xwTu6NsIFiJEkfAjH1EauyGyN90gfNTO8+MXUpS0UsVld6PJ7MVycbc4Xe
LyB39GwSQZmByQYAMCc6t36y6eeSuCo25TyX4BygDeHzbgftBrI4zbdlTvpw
Op1KdSUbc4Vkc6AInZtEUE5gsgEAzIn+rR/bME4SfyVxUHOsyAo0gEoPx6uX
hNyQ7G3QOYbMpcxkY66yrZYAkIL+TSIoGzDZAADmRP/WLxSSj7+i6xtsakAH
mjrok8iUr7t+JS190e/KmPQRCAQUjaxsmQK7PW2dNABk0b9JBGUDJhsAwJwY
wvp5vWmD+dl+EEg51yMx6bHPN3039o1sbdA9Hk/uI0skBhEaiLkChWMIkwjK
A0w2AIA5MYr1czrlg2pYHxUp53pkmnewcVQx2vjpRfY32HSeycnJdIdPNz0A
UIpRTCIoAzDZAADmxCjWT7b+FdkefrhD4qMi5dwIZEn6IIMoGdYM6TwZlsYA
UIpRTCIoAzDZAADmxEDWTzawn32TrvVlghygZXvTJ32wAXXpOkjKzgqiVNKv
kwCQCdgQoBqYbAAAc2Is6+fxSPxMpJwbkqxJH2wPF6JH2N1kKxKQTW5fAHLC
WCYRGBpMNgCAOTGc9Utq6BD60pe+I/FRv/e972l9gaAIWK3WrAF18/Py3T0G
BjS5ZFAmGM4kAuOCyQYAMCeGs36JBJAvfamVLnYEAoHR0VGapPxXf/VX5Oug
iNZXCvKEraLcKpfFIZtpTnZEiV1QCIYzicC4YLIBAMyJEa3f5CS57FFJLsD8
/DxbJYlgt9s7RHgRaBP94/V6JYPoYcpXDQzIp3ug5AAoECOaRGBQMNkAAObE
oNbvv/03odCuRESwqcpZSWgT4t8SbUL8XqpNMvfUBiWFDIdkmCRVlGWLXKG7
BygKBjWJwIhgsgEAzIlBrR/NSpaoD7Y7doFYrVZoE5Uhz5YdiOQdRkflpQcy
zUFRMKhJBEYEkw0AYE4Mav1ocI4kIId9Z15SEtqESCEa1kW1CRqOFAIrIZPr
mKWTHsg0B8XCoCYRGBFMNgCAOdGT9ZvxuxpEfzNtE7oE8/PztCwSESCTk5PE
53c6neS/X/rSl9QUIJmBNskDtnk9UZr0R5AeQAU4HZlEUOZgsgEAzIlurF8k
7D9ki/mb2dXHslgZSVKX9Utf+huOG+E4nmx/9EfOHTs6ZPPQdYJEmwQCAaJN
Jk3fJM9ut0seFH0mYqkBFLkCJYfTi0kE5Q8mGwDAnOjF+tHm17aHHDYLx9V2
+m7m8kvz8/Ner3f//oE//uMBsQpW2obXdH2EQF194vNT51990ZEjRDeRy3M6
nabSJqFQSPIciMBcFlc9ZLsKQnqAosPpxCQCE4DJBgAwJ/qwfnen+J0WrsHl
D/o6aznOUu++FFHy+8Qrl/VOkwVIBojTWwbapAzKCLNVy8hYpAu4gvQApYDT
hUkEpgCTDQBgTvRg/SJTfIuFs7TwU5Gb+amP5YIFSAYS2sTr9RJX3+PxUG3C
9uPWCcZtcUKTd5I5elS6pFWsYQVAFk4HJhGYBEw2AIA50d76RT7lW9Zwlp38
1N3l5YWgezO5JEunb1b5kTIIkNKVY52fny8PbaKHMsJyD20e0gOoCae5SQSm
AZMNAGBOtLZ+kVlft4Vb08J/Ki52xNQHV+8OKl38EEknQLTqByHRJgTq+bO5
1TpBwxYnk5OTzOW0QnoAleHgEAK1wGQDAJgTja1f+KzLZuFsh/xhKjaoGMlf
fSxnFCCp7UF0AfXtR0dHoU3IAZkTeiA9gMpwcAiBWmCyAQDMiabWjzb4aHD5
Z+LfiasPS7dvNl/5kVGADAwYKVVZVpsYqIywohYnf/u3f8scL4g0c6AyHBxC
oBaYbAAAc6Kd9Utu8MGSU8uPDGQQIMSJLY+Of7SMcCAQoK6+0+k0qDaZn5/f
t2+f3G9AegC14eAQArXAZAMAmBPNrB9NNk9LevUhBmvlkpZOnFXisqarmGSE
ElAFIatN9FxG2G6300uNB559OzFeHR2QHkAlODiEQC0w2QAA5kQj60cbfCSS
zZOY9XUKoVeyDQdng74hl2NN7iV5MwgQsvF8Ue7FkOitxUlra2sieYR8ERcg
kzRYDgDVgEMIVAOTDQBgTjSxfkkNPtifiU3PpfqC9gFJoCwui7iv6QQIXqrL
or42CQQCyRcQbzvIm1khAk2AQwhUA5MNAGBOtLB+VEokJ5snIa8+4tCVEeU5
6V5vWgFihiis4lKKFieSZojkv+SbTie0B1AbOIRANTDZAADmRHXrR5PNLTbX
2bD8DrFlDtnMjkjQXZ9vL0Li3qbLQ6fFeLEIUhTy0yaSRY6BgQF2QQQAFYBD
CFQDkw0AYE7Utn60wUemxYsMDQfpj3JN+mAJhTKlgdjtWAQpOVSb/PjHwS9/
eZRoDnF77Pd//4/JgBO1Mi9CG3/YyXgAoDpwCIFqYLIBAMyJoawfXRYpqBjv
/HymNBAsgpQa8mydTvaxB37/91NWRqxW6yTaCgItMJRJBMYGkw0AYE6MZP3y
TfpgGR3NFIVlty8j5KcUeL0ZHnvoq1/1tLbGGqkXpXk6AHlgJJMIDA4mGwDA
nBjI+hWS9MGSOQqLbE5nmTQl1AOTk0J5scxPW5ngoCF88hF6AOSPgUwiMDqY
bAAAc2Ic61do0ocsPJ/JJaY9QfAavhCyhrpZrcJSlEJm/K6GWJAW1AcoKsYx
icDwYLIBAMyJcaxfEZI+ZJmczLIIkpd7DATdQbRbhgg3Tuy3kscCk7gKZrE5
HrJxxYnEAyCBcUwiMDyYbAAAc2IY61e8pA9ZsvrJdjs0iAIypngUpukin/It
azjbIf/UCWFKlECQAjNjGJMIjA8mGwDAnBjF+hU36UOWUChLbgI0SC6Q50Oe
UubHODCQdzzb3Sl+p4Vb08J/GqGCFOoDFBWjmERQBmCyAQDMCayfhEAgu/MM
DcJC46yyPrrW1oKaqkSm+BYLZ2nhpyLkP5fc9UR+1Hb6bhbvPoDZgUkEqoHJ
BgAwJ7B+LLkkLFANgpz0ZXHNyOPJ/rjIDl5vgacSc38sO/mpu8L/YuqjyIUI
gMmBSQSqgckGADAnsH7pIE515mJNyXFE5uyMFwzKtg6U2Yoh0yJh/yEbZ7G5
zoZj36GFCKA+QDGBSQSqgckGADAnsH6ZIRokRwe7tVUIxzLDUgh5Jl5v9iCr
hDQrTtsU2uDDdsgfTkgNqj5Kmw0EzAZMIlANTDYAgDmB9cuFYDB7Qnqyv12W
rdKJsCLyKkctVkzdIZDU4IMFLT9A8YBJBKqByQYAMCewfrkzOZlrLBZNcygP
GaJUdBRbdwjQZHOoD6ACMIlANTDZAADmBNZPKTQfJGuSdfJGXHfiwBfXIS81
RGp5vQpWfKjgKkkaPm3wkUg2T/rBrK/bIt9wcDboG3I51sTkicXhOhEMLwOQ
HZhEoBqYbAAAcwLrlx/Ex8499yGxkf09HmFBRJ9KhFwVUUlEWym9L5rzUhqS
GnwwP6NdYKQtPyJTvu7/v727R20riMIAmm24zhKyAVVpUqdNEbQFC7wGr0EQ
0msDBncu1QfVCmpSBFcmBEHmZeyJbGxFv1eW7jlMZaSnKS4fvsy8mfet45jP
ri56DuZlVSKRMIoNyEn6bam0EmvtSlrsRMoXSwuzzf0XWyo9VPn10aibyVqr
OYu7y/Y7/3ql4KOXzf95rvuo3cqHy/HPh7/cTYYfy4feXo5/73OmnAaRSBjF
BuQk/XaiLoX0+5u0Ia0ZOT/vGoGbm+7/+X0sjpRnlieXeZZfKb+1QbvRRvl6
yAFf9WXzxVbisfvrzhfWNf7+5f46wnu6D9YgEgmj2ICcpN9uTafd3qp1dy4t
b0lqV1JH7U2Wj9pflFFmUr++q/mU9qo8PGrbWL3gY+mBuk8vHKxvgjzeZOVK
dNYhEgmj2ICcpN+e1Le2t1kNeT2j9C+BTcdu1Y1YL+7dgidEImEUG5CT9Nu3
emLtBq9yH3aU2dYTg4/4/sT5bPxl0Otaj4vRxIWErEQkEkaxATlJv0gbHyoV
M/r9bm5Hdzjwc24n18NBd9TVWW8wmlj1YGUikTCKDchJ+h3K4nlTh9qgVduN
MocDnru1a79m468Pfcfw2pIHaxKJhFFsQE7S7/WYTrudTu1t8d22JPX18/Lk
2muU3zpFt9+G3aXoZ58uR+OZBQ82IBIJo9iAnKTf61c6hXaeVTv8avlonz/+
PVSrqy+Yn/UurjQebEwkEkaxATlJP07D/Pvo88v3EsKKRCJhFBuQk/TjJPy4
Hrx787x2Gwj8n0gkjGIDcpJ+AI1IJIxiA3KSfgCNSCSMYgNykn4AjUgkjGID
cpJ+AI1IJIxiA3KSfgCNSCSMYgNykn4AjUgkjGIDcpJ+AI1IJIxiA3KSfgCN
SCSMYgNykn4AjUgkjGIDcpJ+AI1IJIxiA3KSfgCNSCSMYgNykn4AjUgkjGID
cpJ+AI1IJIxiA3KSfgCNSCSMYgNykn4AjUgkjGIDcpJ+AI1IJIxiA3KSfgCN
SCSMYgNykn5wFP4AJ3iqkw==
    "], {{0, 186.79245283018867`}, {724.0754716981131, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{724.0754716981131, 186.79245283018867`},
  PlotRange->{{0, 724.0754716981131}, {0, 186.79245283018867`}}]], "Text",
 CellChangeTimes->{3.94561131365608*^9, 3.946093845394991*^9},
 CellLabel->"In[50]:=",ExpressionUUID->"56df0d81-b84a-0a40-8935-622d3a9520bb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945615970386856*^9, 3.945615990738682*^9}, {
  3.945616055354908*^9, 3.945616056555292*^9}, {3.945616329113766*^9, 
  3.9456163297459545`*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"2a84e9eb-3b52-7d4c-8269-c5737e1783b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "}"}], "]"}], ",", "ptH"}], 
    "]"}], ",", 
   RowBox[{"cyclic", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.945616345620476*^9, 3.9456164106663303`*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"c59ea1e9-aaa1-ba42-8ac2-a180175f33d0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "9"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.945616363395457*^9, 3.945616411439913*^9}, 
   3.946004699418197*^9, 3.9460938517686424`*^9, 3.946286128815033*^9, 
   3.94630413672262*^9, 3.946354299225767*^9, 3.946641450558687*^9, 
   3.94665164426383*^9, 3.946664958394562*^9, 3.946704343842997*^9, 
   3.947009541038946*^9, 3.947045818433208*^9, 3.947163230958145*^9, 
   3.947171549053409*^9, 3.947384358154398*^9, 3.947404255170529*^9, 
   3.9474339162434063`*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"160a11de-5fc4-e941-8860-3f8e684fd0cd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentrocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"G1", ",", "G2", ",", "G3", ",", "G4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"G1", ",", "G2", ",", "G3", ",", "G4"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Baricentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Q", ",", "R", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q", ",", "R"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"G1", ",", "G2", ",", "G3"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
   3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
   3.9455136200666037`*^9}, {3.94561082469837*^9, 3.94561088310631*^9}, {
   3.945611048795094*^9, 3.945611225281727*^9}, {3.945611707609211*^9, 
   3.945611722193455*^9}, 3.946652966770469*^9},
 CellLabel->"In[47]:=",ExpressionUUID->"58f5683c-eea5-5f4d-908b-138ff9f5786b"]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthocenter of a cyclic quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.945610802689909*^9, 3.945610812713859*^9}, {3.945611043737335*^9, 
  3.945611045361271*^9}, {3.94561156951313*^9, 
  3.945611571897038*^9}},ExpressionUUID->"27f808e6-e579-8044-bb27-\
905ebef0af91"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnX9sU2ea7w0UkqCoupn/LC33tspmylbcqXpTaycVMzfRHaJWaHFLFSEo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    "], {{0, 148.75471698113208`}, {522.3396226415094, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{522.3396226415094, 148.75471698113208`},
  PlotRange->{{0, 522.3396226415094}, {0, 148.75471698113208`}}]], "Text",
 CellChangeTimes->{3.946004699433159*^9, 3.946093874356119*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"b9f0a34c-bb41-5b40-8075-20f44c1ed2ab"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "4", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945615970386856*^9, 3.945615990738682*^9}, {
  3.945616055354908*^9, 3.945616056555292*^9}, {3.945616329113766*^9, 
  3.9456163297459545`*^9}, {3.945616452417559*^9, 3.945616453058086*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"289e036b-59cc-294d-8968-9f3882987b07"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "}"}], "]"}], ",", "ptH"}], 
    "]"}], ",", 
   RowBox[{"cyclic", "==", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.945616345620476*^9, 3.9456164106663303`*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"5cb44932-662b-c34f-9d5e-9a4f33e7d9e5"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "-", "b", "-", "c"}], ")"}], "3"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b", "-", "c"}], ")"}], "3"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "-", "b", "+", "c"}], ")"}], "3"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b", "+", "c"}], ")"}], "3"], " ", "p", " ", "q", " ", 
  "r", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{"q", "+", "r"}], ")"}]}], "+", 
       RowBox[{"p", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "q"}], "+", 
          RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "p"}], "-", "q", "+", 
          RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "p"}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", "p"}], "-", 
          RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["a", "4"], " ", "q", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["p", "2"]}], "+", 
          RowBox[{"4", " ", "q", " ", "r"}], "+", 
          RowBox[{"3", " ", "p", " ", 
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "4"], " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "q", " ", 
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}]}], "+", 
          RowBox[{"p", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", "q"}], "+", 
             RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.945616363395457*^9, 3.945616411439913*^9}, 
   3.9456164568814487`*^9, 3.946004700309868*^9, 3.946093879603981*^9, 
   3.946286139083276*^9, 3.946304137587335*^9, 3.946354300080492*^9, 
   3.946641451454262*^9, 3.946651645133545*^9, 3.946664959321087*^9, 
   3.946704344703785*^9, 3.947009541908619*^9, 3.947045819301859*^9, 
   3.947163231892654*^9, 3.947171549989996*^9, 3.947384359150763*^9, 
   3.9474042560942*^9, 3.947433917173935*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"488e4cdb-cb13-a14b-8f15-75ef0f4979ca"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"H1", ",", "H2", ",", "H3", ",", "H4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"H1", ",", "H2", ",", "H3", ",", "H4"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Ortocentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Q", ",", "R", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q", ",", "R"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"H1", ",", "H2", ",", "H3"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945611735225509*^9, 3.945611777816695*^9}, 
   3.946652975162092*^9},
 CellLabel->"In[50]:=",ExpressionUUID->"b3d30327-18b8-3e47-8ce7-7916c293687d"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 RowBox[{
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzsvW9MG1f+/zu698l9MFe6fsgDJK4QEg8ioQghXSq0ggdErZBw1AihZCvL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     "], {{0, 518.2641509433962}, {356.60377358490564`, 0}}, {0, 255},
     ColorFunction->RGBColor,
     ImageResolution->{106., 106.},
     RasterInterpolation->"High"],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSize->{399.67041717154234`, Automatic},
   ImageSizeRaw->{356.60377358490564`, 518.2641509433962},
   PlotRange->{{0, 356.60377358490564`}, {0, 518.2641509433962}}], 
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzsvV9MG1e7/zvnnJtzMRfHl1wgcYQscREpihDSIUIVXBC1soSjVAiljSyD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     "], {{0, 247.92452830188677`}, {448.3018867924528, 0}}, {0, 255},
     ColorFunction->RGBColor,
     ImageResolution->{106., 106.},
     RasterInterpolation->"High"],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSize->{467.66037735849034`, Automatic},
   ImageSizeRaw->{448.3018867924528, 247.92452830188677`},
   PlotRange->{{0, 448.3018867924528}, {0, 247.92452830188677`}}]}]], "Text",
 CellChangeTimes->{
  3.946440201275278*^9, 3.9471623775557427`*^9, 3.9471625297527065`*^9, {
   3.947162797728485*^9, 3.947162818975754*^9}, {3.9475074167407494`*^9, 
   3.9475074204114456`*^9}, 
   3.947507455207796*^9},ExpressionUUID->"20c7ab22-8503-fd4d-9d34-\
15585b88ac29"],

Cell[CellGroupData[{

Cell["X (2)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9},ExpressionUUID->"05a1e3c3-6472-f140-9524-\
e2a0b3b33a84"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "2", "]"}]}]], "Input",
 CellChangeTimes->{3.9471632378229847`*^9},
 CellLabel->"In[58]:=",ExpressionUUID->"4c28bf26-a6ce-8a42-b991-8ad29b361320"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"p", "+", 
      RowBox[{"2", " ", "q"}], "+", "r"}], ",", 
     RowBox[{"p", "+", "q", "+", 
      RowBox[{"2", " ", "r"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ",", "q", ",", 
     RowBox[{"p", "+", "q", "+", 
      RowBox[{"2", " ", "r"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ",", 
     RowBox[{"p", "+", 
      RowBox[{"2", " ", "q"}], "+", "r"}], ",", "r"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9471632384884567`*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"009622e1-f35c-1f41-8dc8-882478cf9f29"]
}, Open  ]],

Cell[CellGroupData[{

Cell["centro[ABCD] = o[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946652419022213*^9, 
  3.9466524225307207`*^9}},ExpressionUUID->"28b2235c-76ad-574f-9544-\
f4db4bea2275"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentrocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946653459801729*^9, 3.946653459849516*^9}, {
   3.946653512593708*^9, 3.9466535138576527`*^9}, 3.9471632153123016`*^9, 
   3.947163248255209*^9},
 CellLabel->"In[59]:=",ExpressionUUID->"3405fa43-c3be-9049-9d7d-59655cad773d"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946653517656973*^9, 3.947163249849266*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"003aab85-b0af-424c-a66d-81d900e9a90b"],

Cell[CellGroupData[{

Cell["o[ABCD] = h[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 
  3.946656375757744*^9}},ExpressionUUID->"4b34b1b8-8997-da40-9474-\
517d10825382"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466579729008904`*^9, 3.94665802570725*^9}, 
   3.946661173503782*^9, {3.947163328838745*^9, 3.9471633289825974`*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"ed6a6cd7-0820-2447-a8de-0e44f63d18cb"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9466580320281744`*^9, 3.9466580467933273`*^9}, 
   3.946661177570804*^9, 3.947163336018553*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"724540c3-a3e3-c946-b887-9a7f32593099"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (4)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 
   3.9471633916954575`*^9},ExpressionUUID->"ced0297d-94ed-1749-88c4-\
03a6cae3388b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "4", "]"}]}]], "Input",
 CellChangeTimes->{{3.946652848034271*^9, 3.946652862820228*^9}, {
  3.947163462695446*^9, 3.9471634695507355`*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"8b8ad98a-fabc-5442-9c12-8867a78272e0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "-", "r"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "-", "q"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"q", "-", "r"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "q"}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "-", "q"}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], " ", "q"}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", "q"}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], ")"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"]}], ")"}], " ", "r"}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"q", "-", "r"}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "-", "r"}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"]}], ")"}], " ", "r"}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], ")"}]}],
      ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], " ", "r"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], "+", 
           SuperscriptBox["b", "2"]}], ")"}], " ", "r"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "-", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9471634701433563`*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"825b81d7-8395-3842-b7d2-8cf99778be21"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ABCD \[TildeEqual]  EFGH", "Subsubsection",
 CellChangeTimes->{{3.946652305430147*^9, 
  3.9466523187024155`*^9}},ExpressionUUID->"317a934c-beb2-e04b-b9b5-\
c653e5ad1673"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"CongruentQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946652848034271*^9, 3.946652862820228*^9}, {
  3.947163705918125*^9, 3.9471637060546265`*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"d7e72bdc-1ce9-184c-a199-077263e596f0"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.94665286720018*^9, 3.947163707325899*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"a5966083-b61b-ff4f-b76d-66930c59e632"],

Cell[CellGroupData[{

Cell["anti[ABCD] = anti[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946652331485712*^9, 
  3.946652333155325*^9}},ExpressionUUID->"fde2c3f8-dcfa-7540-b7e2-\
3c4c3ce248ad"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946652896684032*^9, 3.9466529317537603`*^9}, {
  3.9466530553786163`*^9, 3.9466531403296337`*^9}, {3.9466649430495777`*^9, 
  3.9466649440191708`*^9}, {3.9471637327822647`*^9, 3.9471637329340973`*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"6e3bf791-0a50-7445-a25c-3d153bce468a"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.946653082881653*^9, 3.946653097918194*^9}, {
   3.946653133566473*^9, 3.946653141563978*^9}, 3.946664970965084*^9, 
   3.9471637349427013`*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"99f556fb-5394-9841-baa6-31631b982355"],

Cell[CellGroupData[{

Cell["h[ABCD] = o[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466524303746157`*^9, 
  3.9466524378584743`*^9}},ExpressionUUID->"48f8f996-d73f-7446-8eaa-\
da7a190e952b"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466535333209534`*^9, 3.946653576025535*^9}, 
   3.947163757326559*^9},
 CellLabel->"In[65]:=",ExpressionUUID->"ecbdf5ec-06e9-114f-8922-3c5cc0feca03"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946653579881315*^9, 3.947163760882063*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"92fab156-48ec-d046-96b6-f9359ffd8106"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (5)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}},ExpressionUUID->"5ce734ad-cdc9-e345-8f61-\
47f508758a31"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "5", "]"}]}]], "Input",
 CellChangeTimes->{3.947163825486351*^9},
 CellLabel->"In[66]:=",ExpressionUUID->"defbbd42-deb0-9d42-bfa0-1cc851fc51b1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["p", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            SuperscriptBox["q", "2"], "-", 
            RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "-", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", "q"}], "+", 
         RowBox[{"2", " ", "p", " ", "r"}], "+", 
         RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "+", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["q", "2"], "-", 
         RowBox[{"p", " ", "r"}], "+", 
         RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", "q"}], "-", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947163826272087*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"0225b346-8822-8844-aad3-3903267f5931"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = 4[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.9466521448696795`*^9, 
  3.946652145990576*^9}},ExpressionUUID->"58c4477b-7ddd-3a45-a6fb-\
f3d0ef56f045"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], "-", 
    RowBox[{"4", 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}]}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946652472290485*^9, 3.946652562714979*^9}, {
  3.9471638221684284`*^9, 3.9471638329504223`*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"9af13254-f726-6644-99b5-c25ffdcbe802"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.946652527599394*^9, 3.9466525634312906`*^9}, 
   3.9471638346173496`*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"006c8ec1-e32f-a746-b664-522d2192f349"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[ABCD] = o[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946652357262258*^9, 
  3.9466523628914394`*^9}},ExpressionUUID->"c5b21c3d-4ff5-4e41-a963-\
eecdf6dbb65b"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466532066980743`*^9, 3.946653218633663*^9}, 
   3.947163884959831*^9},
 CellLabel->"In[68]:=",ExpressionUUID->"66276ed3-3d8e-5b4b-b632-7cdf0f5f6043"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946653221157041*^9, 3.9471638869073887`*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"fe64a8a3-346f-8344-8b85-b657cc0617b9"],

Cell[CellGroupData[{

Cell["anti[EFGH] = m[ABCD]", "Subsubsection",
 CellChangeTimes->{{3.9466523907568426`*^9, 
  3.946652395147346*^9}},ExpressionUUID->"7cfa94dd-1c0f-9c4c-9795-\
ab0739d874b5"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946653377777878*^9, 3.946653380017898*^9}, {
   3.9466536695291343`*^9, 3.946653685361061*^9}, 3.947163902623068*^9},
 CellLabel->"In[69]:=",ExpressionUUID->"65451e1b-ed17-3c44-a50d-fddb7b6bdc87"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9466533857687197`*^9, {3.9466536917023377`*^9, 3.946653696090908*^9}, 
   3.947163904058756*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"f6a15ee4-4517-a34d-8f68-fc29da7ffce9"],

Cell[CellGroupData[{

Cell["centro[ABCD] = centro[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946652411061277*^9, 
  3.9466524125870743`*^9}},ExpressionUUID->"5286ce2c-3d3a-d545-a46d-\
a84056574e1e"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentrocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"CentrocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466534114492636`*^9, 3.946653429897539*^9}, {
   3.946653474057304*^9, 3.946653484281248*^9}, 3.947163917047287*^9},
 CellLabel->"In[70]:=",ExpressionUUID->"a015d6a5-1d24-be4c-ad63-123ef34d6fba"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.94665343463616*^9, 3.94665348924649*^9, 
  3.9471639242980633`*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"e8d5fe17-a409-1a4c-8fc4-c91c75e777ba"],

Cell[CellGroupData[{

Cell["o[ABCD] = h[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 
  3.946656375757744*^9}},ExpressionUUID->"e1680357-f829-7a4c-ae37-\
817bd35b7243"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946660335295908*^9, 3.946660336135866*^9}, {
  3.946661220495123*^9, 3.9466612229742393`*^9}, {3.9471639674071712`*^9, 
  3.9471639687259827`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"865f3b2d-2549-8b43-aebc-2a9e8ab9dcd3"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946660521440336*^9, 3.946661359140644*^9, 
  3.9471639805474377`*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"3d59f7c5-cdce-b240-aa1e-16e817821914"],

Cell[CellGroupData[{

Cell["QA - P7 = homot[ABCD, EFGH] = QA - P7", "Subsubsection",
 CellChangeTimes->{{3.946656584360067*^9, 
  3.946656588693731*^9}},ExpressionUUID->"0367e875-fc53-b148-95d9-\
d1b878d99b43"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466624653409977`*^9, 3.9466624660209503`*^9}, 
   3.9471640799909897`*^9},
 CellLabel->"In[73]:=",ExpressionUUID->"4edc7681-a6c8-734d-8465-6c977698d0f4"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.946662473391268*^9, {3.946704354033434*^9, 3.946704368516529*^9}, {
   3.9471640815791626`*^9, 3.9471641035547714`*^9}},
 CellLabel->"Out[73]=",ExpressionUUID->"62c3db89-e93a-a44c-b07b-f13e3501934d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptP", "=", 
   RowBox[{"PerspectorConABC", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"findQACenter", "[", 
  RowBox[{"ptP", ",", "cyclic"}], "]"}]}], "Input",
 CellChangeTimes->{{3.946662485373163*^9, 3.946662485477501*^9}, {
  3.9471640969526978`*^9, 
  3.9471641103104057`*^9}},ExpressionUUID->"5af44466-1a4f-f84b-aba7-\
1f818857e3ea"],

Cell[BoxData["\<\"QA-P7\"\>"], "Output",
 CellChangeTimes->{3.946662528277653*^9, 3.946704384384489*^9, 
  3.947164128417824*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"0e70b632-1487-584f-a74f-a610fe063550"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{"ptP", ",", 
   RowBox[{"QAP7", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellLabel->"In[76]:=",ExpressionUUID->"77d17f1a-e712-a642-ad85-c9bc0a183f29"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9471641453828526`*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"20889b0f-6ac5-ae49-b7bb-163a13c2e9a2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (6)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 
   3.9471644572466583`*^9}},ExpressionUUID->"30cd75dc-5b44-674c-ad1c-\
4519a12c971b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "6", "]"}]}]], "Input",
 CellChangeTimes->{3.9471645057907257`*^9},
 CellLabel->"In[77]:=",ExpressionUUID->"2c81808b-54d1-444a-b9a8-04b0f625e553"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "p", " ", 
      RowBox[{"(", 
       RowBox[{"p", "+", "q", "+", "r"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], " ", "p", " ", "q"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "p", " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], " ", "p", " ", "q"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "q", " ", 
      RowBox[{"(", 
       RowBox[{"p", "+", "q", "+", "r"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], " ", "q", " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"q", "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", "p", " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["a", "2"], ",", 
     SuperscriptBox["b", "2"], ",", 
     SuperscriptBox["c", "2"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947164506436434*^9},
 CellLabel->"Out[77]=",ExpressionUUID->"1d586498-d577-eb44-82cf-2531a4994cec"]
}, Open  ]],

Cell["conic (ABCD, EFGH)", "Subsubsection",
 CellChangeTimes->{{3.946652289973606*^9, 
  3.946652293875118*^9}},ExpressionUUID->"d61e2684-c8de-fc41-a156-\
3ac70903d76c"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"conconicQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466527597458487`*^9, 3.946652790474346*^9}, {
  3.947164486920521*^9, 3.9471645112946377`*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"28e099c9-57e7-554d-880d-26372ed85b66"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946652793253483*^9, 3.947164514031698*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"2f678782-79be-b34a-b86e-3bf8a21069c6"],

Cell[CellGroupData[{

Cell["dp (ABDC) = dp (EFGH)", "Subsubsection",
 CellChangeTimes->{{3.9466563905365334`*^9, 
  3.9466564154294577`*^9}},ExpressionUUID->"a878c7e0-34e0-2d43-afc1-\
95a5b9f175c7"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946661105543022*^9, 3.946661128177252*^9}, 
   3.946661324446525*^9, 3.946661690366436*^9, 3.947164539302868*^9},
 CellLabel->"In[79]:=",ExpressionUUID->"3be89c6f-5c10-c94d-8ff0-cfb4bec0aeeb"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9466611509653034`*^9, 3.946661681167404*^9, 
  3.947164540774729*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"7fd562b5-a942-0643-8a6c-d5754bec28b3"],

Cell[CellGroupData[{

Cell["dp(ABDC) = dp(EFHG)", "Subsubsection",
 CellChangeTimes->{{3.946656394991411*^9, 3.94665639905332*^9}, {
  3.946656459565307*^9, 
  3.9466565010948253`*^9}},ExpressionUUID->"b81a2928-ab78-a746-a344-\
e8a16836a48f"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptD", ",", "ptC"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptH", ",", "ptG"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466617048783054`*^9, 3.9466617140065746`*^9}, 
   3.9471645614142303`*^9},
 CellLabel->"In[80]:=",ExpressionUUID->"75886ffa-a88b-b643-ab72-131b7c93098d"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946661715611376*^9, 3.947164562956312*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"79363946-33a7-0442-844c-3ab64a56fddd"],

Cell[CellGroupData[{

Cell["dp (ACBD) = dp (EGFH)", "Subsubsection",
 CellChangeTimes->{{3.9466565187440186`*^9, 
  3.9466565219810677`*^9}},ExpressionUUID->"5149a6bb-fcf7-a844-9eef-\
1e2ed9463143"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptC", ",", "ptB", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptG", ",", "ptF", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946661883734415*^9, 3.946661932398056*^9}, 
   3.9471646092781506`*^9},
 CellLabel->"In[81]:=",ExpressionUUID->"3e00d12c-f4d4-7842-8bc9-f9e6ff2856b5"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9466619177673836`*^9, 3.9471646107839336`*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"0b5d30f6-101a-634d-be62-bfc66ce9ab9c"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (15)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.947163391695458*^9, {3.947163787230065*^9, 
   3.94716378728674*^9}, {3.947164457181654*^9, 3.9471644572466593`*^9}, {
   3.9474339255786667`*^9, 3.9474339262981033`*^9}, 3.9474372881951256`*^9, 
   3.947439475998659*^9},ExpressionUUID->"c25fd74d-deeb-3842-9dd9-\
2e3e413d88a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Simplificar", ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{"CentralQuadrilateral", "[", "15", "]"}], "]"}], "/.", 
        "sustS"}], ",", "cyclic"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.947164505790726*^9, {3.9474339321153507`*^9, 3.9474339341630764`*^9}, {
   3.9474370760208626`*^9, 3.947437103308193*^9}, {3.947438344666109*^9, 
   3.94743835059354*^9}, {3.9474384148740253`*^9, 3.9474384259698296`*^9}, 
   3.9474387793371086`*^9, {3.9474390720244083`*^9, 3.9474390813683376`*^9}, {
   3.947439458102724*^9, 3.947439464990761*^9}, {3.947441249604542*^9, 
   3.947441249723095*^9}},ExpressionUUID->"271e5413-64a3-cb4b-8e9f-\
ce092ad7786b"],

Cell["dp (ABDC) = dp (EFHG)", "Subsubsection",
 CellChangeTimes->{{3.9466563905365334`*^9, 3.9466564154294577`*^9}, {
  3.9474371430034237`*^9, 
  3.947437144419607*^9}},ExpressionUUID->"a5514448-4955-e849-8bf5-\
3cb4e3843992"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"DiagonalPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptD", ",", "ptC"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947439103554308*^9, 3.9474391048237495`*^9}, {
  3.9474404816135178`*^9, 3.947440484140732*^9}},
 CellLabel->
  "In[115]:=",ExpressionUUID->"e058c8f3-f1a9-654d-8f59-86b82dcb58c0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "q", ",", "r"}], "}"}]], "Output",
 CellChangeTimes->{3.9474391058483143`*^9, 3.9474405028002777`*^9},
 CellLabel->
  "Out[115]=",ExpressionUUID->"96288047-f551-7f47-abf8-8e18be3bd13c"]
}, Open  ]],

Cell["\<\
In  order  to  prove  that ABDC and EFHG have the same diagonal point is is \
enough to verify that P lies on the diagonals EH and FG\
\>", "Text",
 CellChangeTimes->{{3.9474405094150677`*^9, 
  3.947440575612816*^9}},ExpressionUUID->"f626c014-bbce-5c45-be67-\
ce7c3ce588a1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptE", ",", "ptH"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9474407592704086`*^9, 3.9474408286847687`*^9}},
 CellLabel->
  "In[119]:=",ExpressionUUID->"59c59840-80da-1745-9037-d5a9f7446ff2"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474407845812206`*^9, 3.94744082945364*^9}},
 CellLabel->
  "Out[119]=",ExpressionUUID->"63f69d1d-c225-b942-ba2a-80fd079c961e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptF", ",", "ptG"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.947439170954399*^9, 3.9474392827510414`*^9}, {
  3.947439972046669*^9, 3.9474399804072742`*^9}, {3.9474400146384487`*^9, 
  3.94744004609449*^9}, {3.947440835844679*^9, 3.947440846596712*^9}},
 CellLabel->
  "In[120]:=",ExpressionUUID->"155f4d04-0573-9140-98e3-e9d0091eb75b"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474392117457676`*^9, 3.9474392861660576`*^9}, {
   3.9474400072625923`*^9, 3.947440027544754*^9}, 3.947440069074955*^9, 
   3.947440847588087*^9},
 CellLabel->
  "Out[120]=",ExpressionUUID->"e4712005-bcae-664b-bd14-39183a36c833"]
}, Open  ]],

Cell["dp(ACBD) = dp(EGFH)", "Subsubsection",
 CellChangeTimes->{{3.946656394991411*^9, 3.94665639905332*^9}, {
  3.946656459565307*^9, 3.946656501094825*^9}, {3.9474363089497128`*^9, 
  3.947436318261812*^9}},ExpressionUUID->"cebadb11-dfa4-a64c-bc90-\
3066f299448e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"DiagonalPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptC", ",", "ptB", ",", "ptD"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947439103554308*^9, 3.9474391048237495`*^9}, {
  3.9474404816135178`*^9, 3.947440484140732*^9}, {3.9474410378923492`*^9, 
  3.947441041771288*^9}},
 CellLabel->
  "In[121]:=",ExpressionUUID->"b924521e-7c97-4f4f-89d2-b041e1e49607"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "p"}], ",", 
   RowBox[{"-", "q"}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.9474391058483143`*^9, 3.9474405028002777`*^9, 
  3.9474410445339108`*^9},
 CellLabel->
  "Out[121]=",ExpressionUUID->"f774e088-e7a8-854b-81be-964acc0d6c01"]
}, Open  ]],

Cell["\<\
In  order  to  prove  that ACBD and EGFH have the same diagonal point is is \
enough to verify that P lies on the diagonals EF and GH\
\>", "Text",
 CellChangeTimes->{{3.9474405094150677`*^9, 3.947440575612816*^9}, {
  3.9474410518278923`*^9, 
  3.947441071907751*^9}},ExpressionUUID->"c4b835e7-a8a2-0943-b4d0-\
9b8d0455cb86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptE", ",", "ptF"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9474407592704086`*^9, 3.9474408286847687`*^9}, 
   3.9474410775723305`*^9},
 CellLabel->
  "In[122]:=",ExpressionUUID->"20e6b663-b1f7-4c4b-94ce-acb6202c41bd"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474407845812206`*^9, 3.94744082945364*^9}, 
   3.9474410787684193`*^9},
 CellLabel->
  "Out[122]=",ExpressionUUID->"9715554b-1ca3-fe43-903d-7475249a9965"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptG", ",", "ptH"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.947439170954399*^9, 3.9474392827510414`*^9}, {
  3.947439972046669*^9, 3.9474399804072742`*^9}, {3.9474400146384487`*^9, 
  3.94744004609449*^9}, {3.947440835844679*^9, 3.947440846596712*^9}, {
  3.947441082707737*^9, 3.9474410849156075`*^9}},
 CellLabel->
  "In[123]:=",ExpressionUUID->"6f8b4e9a-b0aa-1f4e-8ee1-a805994ed04f"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474392117457676`*^9, 3.9474392861660576`*^9}, {
   3.9474400072625923`*^9, 3.947440027544754*^9}, 3.947440069074955*^9, 
   3.947440847588087*^9, 3.947441085882168*^9},
 CellLabel->
  "Out[123]=",ExpressionUUID->"b17d6c2a-5bf3-2748-ab3c-239bd4ac5518"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (16)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.947163391695458*^9, {3.947163787230065*^9, 
   3.94716378728674*^9}, {3.947164457181654*^9, 3.9471644572466593`*^9}, {
   3.9474339255786667`*^9, 3.9474339262981033`*^9}, 3.9474372881951256`*^9, 
   3.947439475998659*^9, {3.9474411505478325`*^9, 
   3.947441150595703*^9}},ExpressionUUID->"2743c93c-6e02-b54e-b186-\
5dc5fda999d0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Simplificar", ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{"CentralQuadrilateral", "[", "16", "]"}], "]"}], "/.", 
        "sustS"}], ",", "cyclic"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.947164505790726*^9, {3.9474339321153507`*^9, 3.9474339341630764`*^9}, {
   3.9474370760208626`*^9, 3.947437103308193*^9}, {3.947438344666109*^9, 
   3.94743835059354*^9}, {3.9474384148740253`*^9, 3.9474384259698296`*^9}, 
   3.9474387793371086`*^9, {3.9474390720244083`*^9, 3.9474390813683376`*^9}, {
   3.947439458102724*^9, 3.947439464990761*^9}, {3.9474411809964733`*^9, 
   3.9474411810836525`*^9}, {3.94744125885141*^9, 
   3.9474412589797096`*^9}},ExpressionUUID->"26921ce8-3337-a64b-8145-\
752ceac047da"],

Cell["dp (ABDC) = dp (EFHG)", "Subsubsection",
 CellChangeTimes->{{3.9466563905365334`*^9, 3.9466564154294577`*^9}, {
  3.9474371430034237`*^9, 
  3.947437144419607*^9}},ExpressionUUID->"780db158-5009-0944-a114-\
2a682417516b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"DiagonalPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptD", ",", "ptC"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947439103554308*^9, 3.9474391048237495`*^9}, {
  3.9474404816135178`*^9, 3.947440484140732*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"3e12d1be-71fc-c44e-b627-850ee216594e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "q", ",", "r"}], "}"}]], "Output",
 CellChangeTimes->{3.9474391058483143`*^9, 3.9474405028002777`*^9, 
  3.9474411921064014`*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"2bd2a29f-e573-0d4b-b27f-67aa002fbc70"]
}, Open  ]],

Cell["\<\
In  order  to  prove  that ABDC and EFHG have the same diagonal point is is \
enough to verify that P lies on the diagonals EH and FG\
\>", "Text",
 CellChangeTimes->{{3.9474405094150677`*^9, 
  3.947440575612816*^9}},ExpressionUUID->"27ef9223-8e03-6041-a4a8-\
accee3656692"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptE", ",", "ptH"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9474407592704086`*^9, 3.9474408286847687`*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"323a94f4-e88b-1f45-9758-300e5c3852a9"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474407845812206`*^9, 3.94744082945364*^9}, 
   3.947441196449812*^9},
 CellLabel->
  "Out[127]=",ExpressionUUID->"4b6b1a52-86f7-9b4f-b8ab-e6fbc1de6274"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptF", ",", "ptG"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.947439170954399*^9, 3.9474392827510414`*^9}, {
  3.947439972046669*^9, 3.9474399804072742`*^9}, {3.9474400146384487`*^9, 
  3.94744004609449*^9}, {3.947440835844679*^9, 3.947440846596712*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"ad17a7ac-f57a-3e46-b72d-cae3b4f1d245"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474392117457676`*^9, 3.9474392861660576`*^9}, {
   3.9474400072625923`*^9, 3.947440027544754*^9}, 3.947440069074955*^9, 
   3.947440847588087*^9, 3.9474412005546474`*^9},
 CellLabel->
  "Out[128]=",ExpressionUUID->"531d49f1-1e1e-4a47-a70b-ad89b9bd8c5f"]
}, Open  ]],

Cell["dp(ACBD) = dp(EGFH)", "Subsubsection",
 CellChangeTimes->{{3.946656394991411*^9, 3.94665639905332*^9}, {
  3.946656459565307*^9, 3.946656501094825*^9}, {3.9474363089497128`*^9, 
  3.947436318261812*^9}},ExpressionUUID->"c7be58c6-3b10-d541-bc2c-\
cb61a0b6ba26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"DiagonalPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptC", ",", "ptB", ",", "ptD"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947439103554308*^9, 3.9474391048237495`*^9}, {
  3.9474404816135178`*^9, 3.947440484140732*^9}, {3.9474410378923492`*^9, 
  3.947441041771288*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"93ef5240-aceb-224b-9a73-f51884976057"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "p"}], ",", 
   RowBox[{"-", "q"}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.9474391058483143`*^9, 3.9474405028002777`*^9, 
  3.9474410445339108`*^9, 3.9474412026504726`*^9},
 CellLabel->
  "Out[129]=",ExpressionUUID->"342b657e-e1fb-5746-bc15-1afc9c8db650"]
}, Open  ]],

Cell["\<\
In  order  to  prove  that ACBD and EGFH have the same diagonal point is is \
enough to verify that P lies on the diagonals EF and GH\
\>", "Text",
 CellChangeTimes->{{3.9474405094150677`*^9, 3.947440575612816*^9}, {
  3.9474410518278923`*^9, 
  3.947441071907751*^9}},ExpressionUUID->"21f4c727-d0d0-674a-9c05-\
4f312a63233e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptE", ",", "ptF"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9474407592704086`*^9, 3.9474408286847687`*^9}, 
   3.9474410775723305`*^9},
 CellLabel->
  "In[130]:=",ExpressionUUID->"0724550f-1e57-2c4c-b717-41b6d7d16536"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474407845812206`*^9, 3.94744082945364*^9}, 
   3.9474410787684193`*^9, 3.9474412045393734`*^9},
 CellLabel->
  "Out[130]=",ExpressionUUID->"f9e5a995-efa4-ce43-b270-47dbe33fdff5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptG", ",", "ptH"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.947439170954399*^9, 3.9474392827510414`*^9}, {
  3.947439972046669*^9, 3.9474399804072742`*^9}, {3.9474400146384487`*^9, 
  3.94744004609449*^9}, {3.947440835844679*^9, 3.947440846596712*^9}, {
  3.947441082707737*^9, 3.9474410849156075`*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"865c6660-add9-ab40-a83c-24d10fed9196"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474392117457676`*^9, 3.9474392861660576`*^9}, {
   3.9474400072625923`*^9, 3.947440027544754*^9}, 3.947440069074955*^9, 
   3.947440847588087*^9, 3.947441085882168*^9, 3.9474412063338184`*^9},
 CellLabel->
  "Out[131]=",ExpressionUUID->"ca9b2224-242c-3c49-90b6-481dea47485a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (20)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.947163391695458*^9, {3.947163787230065*^9, 
   3.94716378728674*^9}, {3.947164457181654*^9, 3.9471644572466593`*^9}, {
   3.9471647716057234`*^9, 
   3.947164771662615*^9}},ExpressionUUID->"59456c32-4674-e34c-8b4d-\
1bf6e8405536"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "20", "]"}]}]], "Input",
 CellChangeTimes->{3.947164786551319*^9},
 CellLabel->"In[82]:=",ExpressionUUID->"240fc9f4-5b4e-d748-8c9a-609cb536d8ec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"8", " ", "q", " ", "r"}], "+", 
         RowBox[{"4", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "-", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"4", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "-", 
              RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p"}], "-", "q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"4", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", 
         RowBox[{"3", " ", "q"}], "-", "r"}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "p"}], "+", "q", "+", "r"}], ")"}]}], 
         "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "-", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p"}], "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "p", " ", "q"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"8", " ", "p", " ", "r"}], "+", 
         RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "-", 
         RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "p"}], "+", 
         RowBox[{"3", " ", "q"}], "+", 
         RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "+", 
         RowBox[{"2", " ", "p", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "+", 
         RowBox[{"4", " ", "p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q", "-", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"2", " ", "p", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "-", "q", "+", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "-", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "-", "q", "-", "r"}], ")"}], " ", "r"}], 
         "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "p"}], "+", 
         RowBox[{"2", " ", "q"}], "+", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q"}], "+", 
         RowBox[{"3", " ", "p", " ", "r"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], "2"]}], " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "-", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9471647874432297`*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"01e24797-a8ed-1549-9133-d011a0b465e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ABCD \[TildeEqual]  EFGH", "Subsubsection",
 CellChangeTimes->{{3.946652305430147*^9, 
  3.9466523187024155`*^9}},ExpressionUUID->"70d6cd25-0dab-8542-8629-\
d6b0ef70a099"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"CongruentQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946652872436685*^9, 3.946652881498266*^9}, {
  3.9471647828086185`*^9, 3.947164798926075*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"32813bc5-6e60-fd4f-a95d-5f66fbf1a64b"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946652882550041*^9, 3.947164802428446*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"1c450a23-1d2e-9145-9cd5-b4233cd209da"],

Cell[CellGroupData[{

Cell["o[ABCD] = h[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 
  3.946656375757744*^9}},ExpressionUUID->"ff968519-5802-294c-ac0a-\
ca77f5dbc8eb"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946660393223864*^9, 3.946660394783382*^9}, 
   3.94666059484061*^9, {3.9466612275190887`*^9, 3.946661228070614*^9}, 
   3.947164855990406*^9},
 CellLabel->"In[85]:=",ExpressionUUID->"5a771eb1-103b-f74b-bf0e-9696f507682a"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946652882550041*^9, 3.947164802428446*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"c47c669d-f9ce-bf4f-92b6-9644cc740c20"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (54)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 3.9471644572466583`*^9}, {
   3.9471647716057224`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}},ExpressionUUID->"1130aa81-64d7-b84f-968f-\
88d49739c32a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "54", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9471651931257706`*^9, 3.947165204990879*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"cc3d962e-a91a-024d-951b-0052e499fbd0"],

Cell["conic (ABCD, EFGH)", "Subsubsection",
 CellChangeTimes->{{3.946652289973606*^9, 
  3.946652293875118*^9}},ExpressionUUID->"8eb4c4a3-a9b2-474f-bdd1-\
6b7cb56022f2"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"conconicQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466528312740703`*^9, 3.946652832050018*^9}, {
   3.947165168270294*^9, 3.947165178045824*^9}, 3.9471652099665394`*^9},
 CellLabel->"In[88]:=",ExpressionUUID->"35c59029-e229-604e-a30c-3e2a7255373b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946652836765016*^9, 3.947165215519869*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"bb74c176-6671-9f40-94d8-3e56b9993626"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (61)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.947163391695458*^9, {3.947163787230065*^9, 
   3.94716378728674*^9}, {3.947164457181654*^9, 3.9471644572466593`*^9}, {
   3.9474339255786667`*^9, 3.9474339262981033`*^9}, 3.9474372881951256`*^9, 
   3.947439475998659*^9, {3.9474412263078327`*^9, 3.9474412263878117`*^9}, {
   3.9474421948340187`*^9, 3.9474421984329014`*^9}, 
   3.947463581212944*^9},ExpressionUUID->"a518287d-dd36-d341-9abf-\
3ac64fa5a126"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Simplificar", ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{"CentralQuadrilateral", "[", "61", "]"}], "]"}], "/.", 
        "sustS"}], ",", "cyclic"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.947164505790726*^9, {3.9474339321153507`*^9, 3.9474339341630764`*^9}, {
   3.9474370760208626`*^9, 3.947437103308193*^9}, {3.947438344666109*^9, 
   3.94743835059354*^9}, {3.9474384148740253`*^9, 3.9474384259698296`*^9}, 
   3.9474387793371086`*^9, {3.9474390720244083`*^9, 3.9474390813683376`*^9}, {
   3.947439458102724*^9, 3.947439464990761*^9}, {3.947441268707453*^9, 
   3.9474412743240776`*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"645b8d11-7207-7a40-89df-17b0a7c9a712"],

Cell["dp (ABDC) = dp (EFHG)", "Subsubsection",
 CellChangeTimes->{{3.9466563905365334`*^9, 3.9466564154294577`*^9}, {
  3.9474371430034237`*^9, 
  3.947437144419607*^9}},ExpressionUUID->"b68bb03e-2b8e-384e-b241-\
5ce4fde0a4b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"DiagonalPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptD", ",", "ptC"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947439103554308*^9, 3.9474391048237495`*^9}, {
  3.9474404816135178`*^9, 3.947440484140732*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"aa3816fd-791b-7145-bf9e-d1d35fc504ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "q", ",", "r"}], "}"}]], "Output",
 CellChangeTimes->{3.9474391058483143`*^9, 3.9474405028002777`*^9, 
  3.947441282914446*^9, 3.94744136248114*^9},
 CellLabel->
  "Out[137]=",ExpressionUUID->"7ea976ed-a884-bc4c-b96f-09d60109f941"]
}, Open  ]],

Cell["\<\
In  order  to  prove  that ABDC and EFHG have the same diagonal point is is \
enough to verify that P lies on the diagonals EH and FG\
\>", "Text",
 CellChangeTimes->{{3.9474405094150677`*^9, 
  3.947440575612816*^9}},ExpressionUUID->"7fd43d98-4505-5149-85f2-\
7b9a232dfc27"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptE", ",", "ptH"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9474407592704086`*^9, 3.9474408286847687`*^9}},
 CellLabel->
  "In[138]:=",ExpressionUUID->"515abae8-da39-ce43-8fa6-869c319653f2"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474407845812206`*^9, 3.94744082945364*^9}, 
   3.947441284937273*^9, 3.9474413645609474`*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"63039e65-ac5c-464f-9982-56b562aa1778"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptF", ",", "ptG"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.947439170954399*^9, 3.9474392827510414`*^9}, {
  3.947439972046669*^9, 3.9474399804072742`*^9}, {3.9474400146384487`*^9, 
  3.94744004609449*^9}, {3.947440835844679*^9, 3.947440846596712*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"04271872-ce01-d842-9051-1de31c941965"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474392117457676`*^9, 3.9474392861660576`*^9}, {
   3.9474400072625923`*^9, 3.947440027544754*^9}, 3.947440069074955*^9, 
   3.947440847588087*^9, 3.9474413531682873`*^9, 3.947441476821512*^9},
 CellLabel->
  "Out[139]=",ExpressionUUID->"6ab52ba6-2068-2d4f-844a-c449b5a301c9"]
}, Open  ]],

Cell["dp(ACBD) = dp(EGFH)", "Subsubsection",
 CellChangeTimes->{{3.946656394991411*^9, 3.94665639905332*^9}, {
   3.946656459565307*^9, 3.946656501094825*^9}, {3.9474363089497128`*^9, 
   3.947436318261812*^9}, 3.947442185274067*^9, 
   3.9474635734689655`*^9},ExpressionUUID->"d5e7955c-4180-2547-9df4-\
d357d83ab4ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"DiagonalPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptC", ",", "ptB", ",", "ptD"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947439103554308*^9, 3.9474391048237495`*^9}, {
  3.9474404816135178`*^9, 3.947440484140732*^9}, {3.9474410378923492`*^9, 
  3.947441041771288*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"de8b2888-84dc-2245-b42a-dba4bde007f9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "p"}], ",", 
   RowBox[{"-", "q"}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.9474391058483143`*^9, 3.9474405028002777`*^9, 
  3.9474410445339108`*^9, 3.9474416706106625`*^9, 3.947443114480137*^9},
 CellLabel->
  "Out[172]=",ExpressionUUID->"3bc5aa53-d2c5-f24a-8e30-00b26b74293b"]
}, Open  ]],

Cell["\<\
In  order  to  prove  that ACBD and EGFH have the same diagonal point is is \
enough to verify that P lies on the diagonals EF and GH\
\>", "Text",
 CellChangeTimes->{{3.9474405094150677`*^9, 3.947440575612816*^9}, {
  3.9474410518278923`*^9, 
  3.947441071907751*^9}},ExpressionUUID->"178a19c5-6567-2d41-8f07-\
3744bc49aed1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"time", " ", "of", " ", "calculus", " ", "7380", " ", "s"}], " ", 
    "=", " ", 
    RowBox[{"123", " ", "minutes"}]}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{"Det", "[", 
       RowBox[{"{", 
        RowBox[{"ptP", ",", "ptG", ",", "ptH"}], "}"}], "]"}], "]"}], "/.", 
     "sustS"}], ",", "cyclic"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.947439170954399*^9, 3.9474392827510414`*^9}, {
  3.947439972046669*^9, 3.9474399804072742`*^9}, {3.9474400146384487`*^9, 
  3.94744004609449*^9}, {3.947440835844679*^9, 3.947440846596712*^9}, {
  3.947441082707737*^9, 3.9474410849156075`*^9}, {3.947463423101721*^9, 
  3.947463478261757*^9}},ExpressionUUID->"75bba81a-9bf8-5942-9611-\
3c8d918c9c4c"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474392117457676`*^9, 3.9474392861660576`*^9}, {
   3.9474400072625923`*^9, 3.947440027544754*^9}, 3.947440069074955*^9, 
   3.947440847588087*^9, 3.947441085882168*^9, 3.9474422046206856`*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"8c03ed0c-e0cb-e248-ba63-5ca39d86ffbd"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (62)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.947163391695458*^9, {3.947163787230065*^9, 
   3.94716378728674*^9}, {3.947164457181654*^9, 3.9471644572466593`*^9}, {
   3.9474339255786667`*^9, 3.9474339262981033`*^9}, 3.9474372881951256`*^9, 
   3.947439475998659*^9, {3.9474412263078327`*^9, 3.9474412263878117`*^9}, {
   3.9474421948340187`*^9, 3.947442226353096*^9}, 3.947442917671446*^9, 
   3.947475837444006*^9},ExpressionUUID->"a0312ef1-124f-2641-a592-\
ed5d1f7a3378"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Simplificar", ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{"CentralQuadrilateral", "[", "62", "]"}], "]"}], "/.", 
        "sustS"}], ",", "cyclic"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.947164505790726*^9, {3.9474339321153507`*^9, 3.9474339341630764`*^9}, {
   3.9474370760208626`*^9, 3.947437103308193*^9}, {3.947438344666109*^9, 
   3.94743835059354*^9}, {3.9474384148740253`*^9, 3.9474384259698296`*^9}, 
   3.9474387793371086`*^9, {3.9474390720244083`*^9, 3.9474390813683376`*^9}, {
   3.947439458102724*^9, 3.947439464990761*^9}, {3.947441268707453*^9, 
   3.9474412743240776`*^9}, {3.94744223269751*^9, 3.947442232737381*^9}},
 CellLabel->
  "In[182]:=",ExpressionUUID->"16b5435a-f621-ab4c-a66a-454683f4db2e"],

Cell["dp (ABDC) = dp (EFHG)", "Subsubsection",
 CellChangeTimes->{{3.9466563905365334`*^9, 3.9466564154294577`*^9}, {
  3.9474371430034237`*^9, 
  3.947437144419607*^9}},ExpressionUUID->"eceaa623-9ac6-cf44-8d50-\
962bb15d8212"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"DiagonalPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptD", ",", "ptC"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947439103554308*^9, 3.9474391048237495`*^9}, {
  3.9474404816135178`*^9, 3.947440484140732*^9}},
 CellLabel->
  "In[183]:=",ExpressionUUID->"26dec18e-e3a7-aa4f-8718-0142e4a1924b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "q", ",", "r"}], "}"}]], "Output",
 CellChangeTimes->{3.9474391058483143`*^9, 3.9474405028002777`*^9, 
  3.947441282914446*^9, 3.94744136248114*^9, 3.9474422418576527`*^9, 
  3.947463602418272*^9, 3.9474637455892525`*^9},
 CellLabel->
  "Out[183]=",ExpressionUUID->"a3bf468c-985d-e648-84bb-b7b006a6bc78"]
}, Open  ]],

Cell["\<\
In  order  to  prove  that ABDC and EFHG have the same diagonal point is is \
enough to verify that P lies on the diagonals EH and FG\
\>", "Text",
 CellChangeTimes->{{3.9474405094150677`*^9, 
  3.947440575612816*^9}},ExpressionUUID->"8ce8b6da-be02-4c40-af44-\
dceaa78ed1c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptE", ",", "ptH"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9474407592704086`*^9, 3.9474408286847687`*^9}},
 CellLabel->
  "In[184]:=",ExpressionUUID->"1844a2cb-a9cf-cd4d-a2aa-08189eaec7e1"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474407845812206`*^9, 3.94744082945364*^9}, 
   3.947441284937273*^9, 3.9474413645609474`*^9, 3.9474422440319576`*^9, 
   3.947463602693535*^9, 3.9474637458575783`*^9},
 CellLabel->
  "Out[184]=",ExpressionUUID->"ebed73f4-3924-5748-84db-e4aacf17f393"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"time", " ", "of", " ", "calculus", " ", "107", " ", "s"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Expand", "[", 
       RowBox[{"Det", "[", 
        RowBox[{"{", 
         RowBox[{"ptP", ",", "ptF", ",", "ptG"}], "}"}], "]"}], "]"}], "/.", 
      "sustS"}], ",", "cyclic"}], "]"}], "//", "AbsoluteTiming"}]}]], "Input",
 CellChangeTimes->{{3.947439170954399*^9, 3.9474392827510414`*^9}, {
  3.947439972046669*^9, 3.9474399804072742`*^9}, {3.9474400146384487`*^9, 
  3.94744004609449*^9}, {3.947440835844679*^9, 3.947440846596712*^9}, {
  3.9474637033491497`*^9, 3.9474637078456936`*^9}, {3.947475733411644*^9, 
  3.9474757456200256`*^9}},ExpressionUUID->"9c3fff85-9016-d748-9b5c-\
cdc9cde3be15"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474407845812206`*^9, 3.94744082945364*^9}, 
   3.947441284937273*^9, 3.9474413645609474`*^9, 3.9474422440319576`*^9, 
   3.947463602693535*^9, 3.9474637458575783`*^9},
 CellLabel->
  "Out[184]=",ExpressionUUID->"23a3cfba-7a1e-584b-ba07-f9f57a8d0734"],

Cell["dp(ACBD) = dp(EGFH)", "Subsubsection",
 CellChangeTimes->{{3.946656394991411*^9, 3.94665639905332*^9}, {
   3.946656459565307*^9, 3.946656501094825*^9}, {3.9474363089497128`*^9, 
   3.947436318261812*^9}, 3.947442185274067*^9, 3.9474422554333286`*^9, 
   3.9474424681692142`*^9, 
   3.947475832188036*^9},ExpressionUUID->"764197fb-f372-154c-a1d6-\
2edd3e30d335"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"DiagonalPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptC", ",", "ptB", ",", "ptD"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947439103554308*^9, 3.9474391048237495`*^9}, {
  3.9474404816135178`*^9, 3.947440484140732*^9}, {3.9474410378923492`*^9, 
  3.947441041771288*^9}, {3.947463694373356*^9, 3.947463716925226*^9}},
 CellLabel->
  "In[186]:=",ExpressionUUID->"857594d7-3e4d-814b-a286-d3cafc886e5e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "p"}], ",", 
   RowBox[{"-", "q"}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.9474391058483143`*^9, 3.9474405028002777`*^9, 
  3.9474410445339108`*^9, 3.9474416706106625`*^9, 3.947442363098097*^9, 
  3.947463852558075*^9},
 CellLabel->
  "Out[186]=",ExpressionUUID->"f999f495-ced5-1c49-94dd-e030d4f56900"]
}, Open  ]],

Cell["\<\
In  order  to  prove  that ACBD and EGFH have the same diagonal point is is \
enough to verify that P lies on the diagonals EF and GH\
\>", "Text",
 CellChangeTimes->{{3.9474405094150677`*^9, 3.947440575612816*^9}, {
  3.9474410518278923`*^9, 
  3.947441071907751*^9}},ExpressionUUID->"21b30a9e-304a-8740-a232-\
db13c127f90a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"time", " ", "of", " ", "calculus", " ", "7442", " ", "s"}], " ", 
    "=", " ", 
    RowBox[{"124", " ", "minutes"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"Expand", "[", 
        RowBox[{"Det", "[", 
         RowBox[{"{", 
          RowBox[{"ptP", ",", "ptE", ",", "ptF"}], "}"}], "]"}], "]"}], "/.", 
       "sustS"}], "]"}], ",", "cyclic"}], "]"}], "//", 
   "AbsoluteTiming"}]}]], "Input",
 CellChangeTimes->{{3.9474407592704086`*^9, 3.9474408286847687`*^9}, 
   3.9474410775723305`*^9, {3.9474420738902817`*^9, 3.947442081985899*^9}, {
   3.947463728517786*^9, 3.9474637323827953`*^9}, {3.94747575051577*^9, 
   3.9474757569403152`*^9}, {3.94747582372373*^9, 
   3.9474758237885723`*^9}},ExpressionUUID->"21ec2b13-f219-8f48-bdda-\
4fc335cb21aa"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474407845812206`*^9, 3.94744082945364*^9}, 
   3.947441284937273*^9, 3.9474413645609474`*^9, 3.9474422440319576`*^9, 
   3.947463602693535*^9, 3.9474637458575783`*^9},
 CellLabel->
  "Out[184]=",ExpressionUUID->"01c59980-b194-4e40-b17b-948bbaae1e1c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptG", ",", "ptH"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.947439170954399*^9, 3.9474392827510414`*^9}, {
  3.947439972046669*^9, 3.9474399804072742`*^9}, {3.9474400146384487`*^9, 
  3.94744004609449*^9}, {3.947440835844679*^9, 3.947440846596712*^9}, {
  3.947441082707737*^9, 3.9474410849156075`*^9}},
 CellLabel->
  "In[188]:=",ExpressionUUID->"2cb3d374-e3c5-ed4c-8b91-1b69a480777d"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474392117457676`*^9, 3.9474392861660576`*^9}, {
   3.9474400072625923`*^9, 3.947440027544754*^9}, 3.947440069074955*^9, 
   3.947440847588087*^9, 3.947441085882168*^9, 3.9474422046206856`*^9, 
   3.94747129565197*^9},
 CellLabel->
  "Out[188]=",ExpressionUUID->"da55698a-3571-d742-9420-cc2ff2b6c015"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (64)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.947163391695458*^9, {3.947163787230065*^9, 
   3.94716378728674*^9}, {3.947164457181654*^9, 3.9471644572466593`*^9}, {
   3.9471647716057234`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}, 
   3.9471652441100216`*^9},ExpressionUUID->"e09aa374-85bc-9e4c-9d6f-\
88ad5215a098"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "64", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9471651931257706`*^9, 3.947165204990879*^9}, {
  3.9471652500788326`*^9, 3.9471652501426334`*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"2ab36d2e-edcf-c240-b2a7-da54399d7d09"],

Cell["conic (ABCD, EFGH)", "Subsubsection",
 CellChangeTimes->{{3.946652289973606*^9, 
  3.946652293875118*^9}},ExpressionUUID->"28347310-2be8-ca46-9ec3-\
ba18dc966a89"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"conconicQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466528312740703`*^9, 3.946652832050018*^9}, {
   3.947165168270294*^9, 3.947165178045824*^9}, 3.9471652099665394`*^9},
 CellLabel->"In[90]:=",ExpressionUUID->"d63871d5-a8f0-394c-aeee-0db4812a0364"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946652836765016*^9, 3.947165215519869*^9, 
  3.9471652592814255`*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"41d0f6da-25ea-754b-8264-2ca2c7ddb187"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (140)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 3.9471644572466583`*^9}, {
   3.9471647716057224`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}, 3.9471652441100216`*^9, {3.9471653102785034`*^9, 
   3.947165310950321*^9}},ExpressionUUID->"01a4aa19-cbf5-fa47-aa64-\
93559e1aebe7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "140", "]"}]}]], "Input",
 CellChangeTimes->{{3.9471653565738335`*^9, 3.947165357197834*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"e860d0b2-e7b6-f744-822b-4c96c07a5ee0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["p", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "-", "q", "+", "r"}], ")"}]}]}], ")"}]}],
       "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"5", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"5", " ", "p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p"}], "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            SuperscriptBox["q", "2"], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "-", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", 
         RowBox[{"3", " ", "q"}], "-", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "+", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", 
         RowBox[{"2", " ", "q"}], "+", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "-", 
         RowBox[{"p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "p", " ", "q"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"p", " ", "r"}], "+", 
         RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"6", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p"}], "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"5", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "-", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", 
         RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", 
         RowBox[{"3", " ", "q"}], "+", 
         RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "p"}], " ", "q"}], "+", 
         RowBox[{"p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", "q"}], "+", 
         RowBox[{"4", " ", "p", " ", "r"}], "+", 
         RowBox[{"5", " ", "q", " ", "r"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"6", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"5", " ", "q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947165357957794*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"2f0d3065-3ca2-2b49-9e74-4dc5b645ee65"]
}, Open  ]],

Cell[CellGroupData[{

Cell["m[ABCD] = o[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946652439879044*^9, 
  3.946652447010975*^9}},ExpressionUUID->"097c4814-d24f-2447-98b8-\
11179a68722d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466535940727787`*^9, 3.9466536089053516`*^9}, 
   3.9471653529040585`*^9},
 CellLabel->"In[92]:=",ExpressionUUID->"84577907-6ee4-8449-a48a-84cbb6556f3d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946653616170809*^9, 3.947165365768305*^9},
 CellLabel->"Out[92]=",ExpressionUUID->"0d68de8f-987b-1547-9de9-7cb65b1e202d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["o[ABCD] = h[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 
  3.946656375757744*^9}},ExpressionUUID->"3fb155cc-9771-494c-b223-\
5ce5c666a65f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466579729008904`*^9, 3.94665802570725*^9}, 
   3.946661173503782*^9, 3.9471653653743534`*^9},
 CellLabel->"In[93]:=",ExpressionUUID->"9b75135e-0ccc-6649-b1c6-740cb07c4ce3"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9466580320281744`*^9, 3.9466580467933273`*^9}, 
   3.946661177570804*^9, 3.947165531115881*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"d4b56271-fb0f-d043-93b5-24740122347a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["homot[ABCD, EFGH]", "Subsubsection",
 CellChangeTimes->{{3.94665661536796*^9, 
  3.94665661991645*^9}},ExpressionUUID->"576b3604-0740-2f44-a47b-\
25f76e748bad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466631820758085`*^9, 3.9466631844445066`*^9}, 
   3.947165396165945*^9},
 CellLabel->"In[94]:=",ExpressionUUID->"afec135e-f612-1f4b-9b05-22a8b56a38d7"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946663350545542*^9, 3.9471655319057426`*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"a788edb7-85e7-7f4d-b28b-d461a8fa2e94"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (371)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.947163391695458*^9, {3.947163787230065*^9, 
   3.94716378728674*^9}, {3.947164457181654*^9, 3.9471644572466593`*^9}, {
   3.9474339255786667`*^9, 3.9474339262981033`*^9}, 3.9474372881951256`*^9, 
   3.947439475998659*^9, {3.9474429447278366`*^9, 
   3.947442946279684*^9}},ExpressionUUID->"7e40531e-4ca5-af44-86d3-\
5ee1eb1cba94"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Simplificar", ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{"CentralQuadrilateral", "[", "371", "]"}], "]"}], "/.", 
        "sustS"}], ",", "cyclic"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.947164505790726*^9, {3.9474339321153507`*^9, 3.9474339341630764`*^9}, {
   3.9474370760208626`*^9, 3.947437103308193*^9}, {3.947438344666109*^9, 
   3.94743835059354*^9}, {3.9474384148740253`*^9, 3.9474384259698296`*^9}, 
   3.9474387793371086`*^9, {3.9474390720244083`*^9, 3.9474390813683376`*^9}, {
   3.947439458102724*^9, 3.947439464990761*^9}, {3.947441249604542*^9, 
   3.947441249723095*^9}, {3.9474429517999134`*^9, 3.9474429535840263`*^9}, {
   3.94744303318458*^9, 3.947443039200344*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"5f9bebbe-8ba7-0048-81fe-033ffe3171c1"],

Cell["dp (ABDC) = dp (EFHG)", "Subsubsection",
 CellChangeTimes->{{3.9466563905365334`*^9, 3.9466564154294577`*^9}, {
  3.9474371430034237`*^9, 
  3.947437144419607*^9}},ExpressionUUID->"aa358991-d892-284b-931e-\
91cf9355b1fb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"DiagonalPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptD", ",", "ptC"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947439103554308*^9, 3.9474391048237495`*^9}, {
  3.9474404816135178`*^9, 3.947440484140732*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"93970a2a-9233-b747-951e-84964e66b0fd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "q", ",", "r"}], "}"}]], "Output",
 CellChangeTimes->{3.9474391058483143`*^9, 3.9474405028002777`*^9, 
  3.947443022063242*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"dad878aa-eefc-0e45-a98b-9954b2dc75f8"]
}, Open  ]],

Cell["\<\
In  order  to  prove  that ABDC and EFHG have the same diagonal point is is \
enough to verify that P lies on the diagonals EH and FG\
\>", "Text",
 CellChangeTimes->{{3.9474405094150677`*^9, 
  3.947440575612816*^9}},ExpressionUUID->"da97f0dc-0da4-8140-8646-\
35a1634c0f7c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptE", ",", "ptH"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9474407592704086`*^9, 3.9474408286847687`*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"bc4e370d-e331-d341-aae5-f586a639107f"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474407845812206`*^9, 3.94744082945364*^9}, {
  3.947443024746153*^9, 3.9474430441477737`*^9}},
 CellLabel->
  "Out[159]=",ExpressionUUID->"78189b55-2865-4940-a21c-1051659dd48c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptF", ",", "ptG"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.947439170954399*^9, 3.9474392827510414`*^9}, {
  3.947439972046669*^9, 3.9474399804072742`*^9}, {3.9474400146384487`*^9, 
  3.94744004609449*^9}, {3.947440835844679*^9, 3.947440846596712*^9}},
 CellLabel->
  "In[160]:=",ExpressionUUID->"fc269b77-e994-c64e-ba18-430a9a0729db"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474392117457676`*^9, 3.9474392861660576`*^9}, {
   3.9474400072625923`*^9, 3.947440027544754*^9}, 3.947440069074955*^9, 
   3.947440847588087*^9, {3.9474430268997326`*^9, 3.9474430465713196`*^9}},
 CellLabel->
  "Out[160]=",ExpressionUUID->"f214bbdd-4965-5341-92d8-5af43ae839f7"]
}, Open  ]],

Cell["dp(ACBD) = dp(EGFH)", "Subsubsection",
 CellChangeTimes->{{3.946656394991411*^9, 3.94665639905332*^9}, {
  3.946656459565307*^9, 3.946656501094825*^9}, {3.9474363089497128`*^9, 
  3.947436318261812*^9}},ExpressionUUID->"c53f66ad-6361-f64b-8fc7-\
2ea5aeb3d668"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"DiagonalPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptC", ",", "ptB", ",", "ptD"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947439103554308*^9, 3.9474391048237495`*^9}, {
  3.9474404816135178`*^9, 3.947440484140732*^9}, {3.9474410378923492`*^9, 
  3.947441041771288*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"f573b31c-9831-7a41-aaa5-522d8b55916b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "p"}], ",", 
   RowBox[{"-", "q"}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.9474391058483143`*^9, 3.9474405028002777`*^9, 
  3.9474410445339108`*^9, 3.9474430524080486`*^9},
 CellLabel->
  "Out[161]=",ExpressionUUID->"1b007795-b8c5-de48-bc9f-b48987aa57fb"]
}, Open  ]],

Cell["\<\
In  order  to  prove  that ACBD and EGFH have the same diagonal point is is \
enough to verify that P lies on the diagonals EF and GH\
\>", "Text",
 CellChangeTimes->{{3.9474405094150677`*^9, 3.947440575612816*^9}, {
  3.9474410518278923`*^9, 
  3.947441071907751*^9}},ExpressionUUID->"2113a798-fcc1-d244-b909-\
953afbec7ccb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptE", ",", "ptF"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9474407592704086`*^9, 3.9474408286847687`*^9}, 
   3.9474410775723305`*^9},
 CellLabel->
  "In[162]:=",ExpressionUUID->"97890af7-81b6-b442-b058-5387de0b7774"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474407845812206`*^9, 3.94744082945364*^9}, 
   3.9474410787684193`*^9, 3.9474430547397175`*^9},
 CellLabel->
  "Out[162]=",ExpressionUUID->"13c3f5be-7e66-674c-a0f3-1c15956e100a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptG", ",", "ptH"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.947439170954399*^9, 3.9474392827510414`*^9}, {
  3.947439972046669*^9, 3.9474399804072742`*^9}, {3.9474400146384487`*^9, 
  3.94744004609449*^9}, {3.947440835844679*^9, 3.947440846596712*^9}, {
  3.947441082707737*^9, 3.9474410849156075`*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"1196acd2-ec37-0d45-a5b7-6e3d2a058f26"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474392117457676`*^9, 3.9474392861660576`*^9}, {
   3.9474400072625923`*^9, 3.947440027544754*^9}, 3.947440069074955*^9, 
   3.947440847588087*^9, 3.947441085882168*^9, 3.947443056873554*^9},
 CellLabel->
  "Out[163]=",ExpressionUUID->"7dae587a-447b-4248-bebd-c5a06b7ee50a"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (372)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.947163391695458*^9, {3.947163787230065*^9, 
   3.94716378728674*^9}, {3.947164457181654*^9, 3.9471644572466593`*^9}, {
   3.9474339255786667`*^9, 3.9474339262981033`*^9}, 3.9474372881951256`*^9, 
   3.947439475998659*^9, {3.9474429447278366`*^9, 3.947442946279684*^9}, {
   3.9474430711999435`*^9, 
   3.947443071304201*^9}},ExpressionUUID->"3a0b7ec8-da24-c54e-88d5-\
6e478fd1a416"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"Simplificar", ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{"CentralQuadrilateral", "[", "372", "]"}], "]"}], "/.", 
        "sustS"}], ",", "cyclic"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.947164505790726*^9, {3.9474339321153507`*^9, 3.9474339341630764`*^9}, {
   3.9474370760208626`*^9, 3.947437103308193*^9}, {3.947438344666109*^9, 
   3.94743835059354*^9}, {3.9474384148740253`*^9, 3.9474384259698296`*^9}, 
   3.9474387793371086`*^9, {3.9474390720244083`*^9, 3.9474390813683376`*^9}, {
   3.947439458102724*^9, 3.947439464990761*^9}, {3.947441249604542*^9, 
   3.947441249723095*^9}, {3.9474429517999134`*^9, 3.9474429535840263`*^9}, {
   3.94744303318458*^9, 3.947443039200344*^9}, {3.947443077984251*^9, 
   3.947443078047882*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"f0799bfd-cb50-7f41-a3bc-1d50e6ba285e"],

Cell["dp (ABDC) = dp (EFHG)", "Subsubsection",
 CellChangeTimes->{{3.9466563905365334`*^9, 3.9466564154294577`*^9}, {
  3.9474371430034237`*^9, 
  3.947437144419607*^9}},ExpressionUUID->"57b9f11c-99f6-5549-b4bb-\
a637314cbeb9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"DiagonalPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptD", ",", "ptC"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947439103554308*^9, 3.9474391048237495`*^9}, {
  3.9474404816135178`*^9, 3.947440484140732*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"bb9e6354-ab17-8c44-b88e-e593ed4b5936"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "q", ",", "r"}], "}"}]], "Output",
 CellChangeTimes->{3.9474391058483143`*^9, 3.9474405028002777`*^9, 
  3.947443022063242*^9, 3.9474430818622417`*^9},
 CellLabel->
  "Out[165]=",ExpressionUUID->"5c873184-2f6f-6e45-b952-8784c90b8bac"]
}, Open  ]],

Cell["\<\
In  order  to  prove  that ABDC and EFHG have the same diagonal point is is \
enough to verify that P lies on the diagonals EH and FG\
\>", "Text",
 CellChangeTimes->{{3.9474405094150677`*^9, 
  3.947440575612816*^9}},ExpressionUUID->"1947eedc-7631-b847-a194-\
848e76047080"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptE", ",", "ptH"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9474407592704086`*^9, 3.9474408286847687`*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"263ffdf6-77c0-3947-b712-0e1c6e7b0cea"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474407845812206`*^9, 3.94744082945364*^9}, {
   3.947443024746153*^9, 3.9474430441477737`*^9}, 3.9474430836255074`*^9},
 CellLabel->
  "Out[166]=",ExpressionUUID->"065d764d-5003-614d-96b0-c2a13cfccf26"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptF", ",", "ptG"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.947439170954399*^9, 3.9474392827510414`*^9}, {
  3.947439972046669*^9, 3.9474399804072742`*^9}, {3.9474400146384487`*^9, 
  3.94744004609449*^9}, {3.947440835844679*^9, 3.947440846596712*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"2d8615ca-a857-9c45-a012-f4c6590d6b96"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474392117457676`*^9, 3.9474392861660576`*^9}, {
   3.9474400072625923`*^9, 3.947440027544754*^9}, 3.947440069074955*^9, 
   3.947440847588087*^9, {3.9474430268997326`*^9, 3.9474430465713196`*^9}, 
   3.9474430849709854`*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"7029f759-d34a-0248-9871-907bb1484415"]
}, Open  ]],

Cell["dp(ACBD) = dp(EGFH)", "Subsubsection",
 CellChangeTimes->{{3.946656394991411*^9, 3.94665639905332*^9}, {
  3.946656459565307*^9, 3.946656501094825*^9}, {3.9474363089497128`*^9, 
  3.947436318261812*^9}},ExpressionUUID->"29c49ec8-cba0-014e-b31b-\
b39a4bafc32b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptP", "=", 
  RowBox[{"DiagonalPoint", "[", 
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptC", ",", "ptB", ",", "ptD"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947439103554308*^9, 3.9474391048237495`*^9}, {
  3.9474404816135178`*^9, 3.947440484140732*^9}, {3.9474410378923492`*^9, 
  3.947441041771288*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"c2f1b6fe-c894-c24f-ace6-04c2651bb6ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "p"}], ",", 
   RowBox[{"-", "q"}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.9474391058483143`*^9, 3.9474405028002777`*^9, 
  3.9474410445339108`*^9, 3.9474430524080486`*^9, 3.9474430873839073`*^9},
 CellLabel->
  "Out[168]=",ExpressionUUID->"a2ecd23c-e4c4-0c41-a128-e96c9e46f661"]
}, Open  ]],

Cell["\<\
In  order  to  prove  that ACBD and EGFH have the same diagonal point is is \
enough to verify that P lies on the diagonals EF and GH\
\>", "Text",
 CellChangeTimes->{{3.9474405094150677`*^9, 3.947440575612816*^9}, {
  3.9474410518278923`*^9, 
  3.947441071907751*^9}},ExpressionUUID->"14f2946d-05ea-b941-9c5d-\
11051628a68c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptE", ",", "ptF"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9474407592704086`*^9, 3.9474408286847687`*^9}, 
   3.9474410775723305`*^9},
 CellLabel->
  "In[169]:=",ExpressionUUID->"bdf7a18a-e7db-3645-8d92-e8d245dbf279"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474407845812206`*^9, 3.94744082945364*^9}, 
   3.9474410787684193`*^9, 3.9474430547397175`*^9, 3.947443089796835*^9},
 CellLabel->
  "Out[169]=",ExpressionUUID->"56802daa-f2cf-8f48-adee-749448b83ef5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Expand", "[", 
     RowBox[{"Det", "[", 
      RowBox[{"{", 
       RowBox[{"ptP", ",", "ptG", ",", "ptH"}], "}"}], "]"}], "]"}], "/.", 
    "sustS"}], ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.947439170954399*^9, 3.9474392827510414`*^9}, {
  3.947439972046669*^9, 3.9474399804072742`*^9}, {3.9474400146384487`*^9, 
  3.94744004609449*^9}, {3.947440835844679*^9, 3.947440846596712*^9}, {
  3.947441082707737*^9, 3.9474410849156075`*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"7013cf94-c266-154b-92ab-3137489d46a7"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9474392117457676`*^9, 3.9474392861660576`*^9}, {
   3.9474400072625923`*^9, 3.947440027544754*^9}, 3.947440069074955*^9, 
   3.947440847588087*^9, 3.947441085882168*^9, 3.947443056873554*^9, 
   3.9474430922576447`*^9},
 CellLabel->
  "Out[170]=",ExpressionUUID->"a9a0ed39-f038-5e4a-a240-64efa866dbbc"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (376)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 3.9471644572466583`*^9}, {
   3.9471647716057224`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}, 3.9471652441100216`*^9, {3.9471653102785034`*^9, 
   3.947165310950321*^9}, {3.947165499885479*^9, 
   3.9471655007098846`*^9}},ExpressionUUID->"43c6819c-81ba-7f48-a76f-\
ea878cf8be94"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "376", "]"}]}]], "Input",
 CellChangeTimes->{{3.9471655581736794`*^9, 3.9471655602057514`*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"66a683fa-3b6c-f942-9e75-be60ea45fe7d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"12", " ", "q", " ", "r"}], "+", 
         RowBox[{"6", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}], "-", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "-", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "+", 
            RowBox[{"4", " ", "q"}], "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"6", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "-", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"5", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"6", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "-", 
            RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "-", "q", "+", 
            RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "p"}], "+", 
         RowBox[{"5", " ", "q"}], "-", "r"}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", "p"}], "+", "q", "+", "r"}], ")"}]}], 
         "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "p"}], "+", 
         RowBox[{"2", " ", "q"}], "+", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "p"}], "-", 
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"6", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "-", 
         RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "p"}], "+", 
         RowBox[{"5", " ", "q"}], "+", 
         RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p", " ", "q"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"3", " ", "p", " ", "r"}], "+", 
         RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "+", 
         RowBox[{"6", " ", "p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"2", " ", "q"}], "-", 
            RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "p"}], "-", "q", "+", 
         RowBox[{"5", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p"}], "-", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p"}], "-", "q", "-", "r"}], ")"}], " ", "r"}], 
         "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", 
         RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "p"}], "+", 
         RowBox[{"4", " ", "q"}], "+", 
         RowBox[{"5", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p", " ", "q"}], "+", 
         RowBox[{"5", " ", "p", " ", "r"}], "+", 
         RowBox[{"q", " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"4", " ", "q"}], "-", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], "2"]}], " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "-", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947165561083784*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"4f818200-9bc5-8f4c-bfae-a3189dbaeb38"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = 9[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946652151149048*^9, 
  3.946652156803406*^9}},ExpressionUUID->"0d201822-0085-fa4c-81d9-\
2bbf0b291cd9"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], "-", 
    RowBox[{"9", 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}]}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946652602498577*^9, 3.946652606050714*^9}, 
   3.947165555312521*^9},
 CellLabel->"In[96]:=",ExpressionUUID->"c64316c4-71e0-d84b-a2fe-981b3b0e5404"]
}, Open  ]],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.946652606790256*^9, 3.947165563904787*^9},
 CellLabel->"Out[96]=",ExpressionUUID->"1b0d6a26-dcbc-9b41-9364-9bec33a568ed"],

Cell[CellGroupData[{

Cell["o[ABCD] = h[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 
  3.946656375757744*^9}},ExpressionUUID->"eac23133-2e31-d945-9030-\
2fc98765fff7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466579729008904`*^9, 3.94665802570725*^9}, 
   3.946661173503782*^9, 3.947165594549776*^9},
 CellLabel->"In[97]:=",ExpressionUUID->"47494824-5063-6643-8c7c-df6177acd096"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9466580320281744`*^9, 3.9466580467933273`*^9}, 
   3.946661177570804*^9, 3.947165790935091*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"c3c6ce9a-2fe0-a74d-ab9d-1ea1672f46ba"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["homot[ABCD, EFGH]", "Subsubsection",
 CellChangeTimes->{{3.94665661536796*^9, 
  3.94665661991645*^9}},ExpressionUUID->"a2d839c2-4658-ee4d-a712-\
ca83b3b77a74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466631820758085`*^9, 3.9466631844445066`*^9}, 
   3.9471656188375664`*^9},ExpressionUUID->"c3952c9c-f3be-5f49-8d6b-\
b24bc75e121e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946663350545542*^9},
 CellLabel->
  "Out[244]=",ExpressionUUID->"d66aebfb-5305-574e-899a-88c553a9d58c"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (381)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 3.9471644572466583`*^9}, {
   3.9471647716057224`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}, 3.9471652441100216`*^9, {3.9471653102785034`*^9, 
   3.947165310950321*^9}, {3.947165499885479*^9, 3.9471655007098846`*^9}, {
   3.947165712540951*^9, 
   3.9471657134614887`*^9}},ExpressionUUID->"2d854eb7-a100-0645-9952-\
d1dd53cd84b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "381", "]"}]}]], "Input",
 CellChangeTimes->{3.947165864261835*^9},
 CellLabel->"In[98]:=",ExpressionUUID->"16a82691-57cf-684d-872d-a0726ef996f3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"6", " ", "q", " ", "r"}], "+", 
         RowBox[{"3", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "-", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"3", " ", "q", " ", "r"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q", "-", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"5", " ", "p", " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"2", " ", "q"}], "-", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
        ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"3", " ", "q", " ", "r"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "-", 
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"5", " ", "p", " ", "r"}], "-", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"5", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "p"}], "+", "q", "-", 
         RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", 
            RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p", " ", "q"}], "+", 
            SuperscriptBox["q", "2"], "-", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p"}], "+", "q", "-", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "+", 
         RowBox[{"6", " ", "p", " ", "r"}], "+", 
         RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "p"}], "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p"}], "+", "q", "-", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"3", " ", "p", " ", "r"}], "+", 
         RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "-", 
         RowBox[{"3", " ", "p", " ", "r"}], "+", 
         RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p"}], "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "p"}], "-", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "p", " ", "q"}], "+", 
            RowBox[{"5", " ", "p", " ", "r"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p"}], "-", "q", "+", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "p", " ", "q"}], "-", 
         RowBox[{"2", " ", "p", " ", "r"}], "+", 
         RowBox[{"5", " ", "q", " ", "r"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p", " ", "q"}], "+", 
         RowBox[{"2", " ", "p", " ", "r"}], "+", 
         RowBox[{"4", " ", "q", " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "-", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9471658650825195`*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"c10553dd-8a54-9945-8803-b168bb6938ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] / [EFGH] = 9/4", "Subsubsection",
 CellChangeTimes->{{3.946652237509197*^9, 3.9466522438185577`*^9}, 
   3.946652706386442*^9},ExpressionUUID->"ee02c104-87cf-924c-81b6-\
6a467cd23fc0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], "/", 
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946652714426782*^9, 3.946652714514469*^9}, {
  3.9471657411272755`*^9, 3.947165744269247*^9}},
 CellLabel->"In[99]:=",ExpressionUUID->"4c093c89-8513-0745-8a94-53b198eaf73a"],

Cell[BoxData[
 FractionBox["9", "4"]], "Output",
 CellChangeTimes->{3.9466527184485283`*^9, 3.947165868029915*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"a69b4292-b040-b042-97d2-68eb3bf91ba1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[ABCD] = m[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946652351413688*^9, 
  3.946652355075411*^9}},ExpressionUUID->"9d4186f2-2a7a-b94b-bca6-\
086178ab299e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946653187257549*^9, 3.9466531979776363`*^9}, 
   3.947165788125574*^9},
 CellLabel->
  "In[100]:=",ExpressionUUID->"42904d9f-6d16-1b43-ba6c-0965a34972c8"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.94665320099786*^9, 3.947165874406273*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"38533f8d-0fd0-3f4f-bc69-0d7d71be7319"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[EFGH] = centro[ABCD]", "Subsubsection",
 CellChangeTimes->{{3.9466523752607303`*^9, 
  3.9466523780350933`*^9}},ExpressionUUID->"ad627b1a-f9af-8348-bcdc-\
be1d9767756b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   RowBox[{"CentrocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946653233971178*^9, 3.946653270000965*^9}, {
   3.946653709264999*^9, 3.9466537102414265`*^9}, 3.947165806109743*^9},
 CellLabel->
  "In[102]:=",ExpressionUUID->"f3af403a-2e73-3a48-ad74-036b454ba56b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.946653258113069*^9, 3.9466532783858223`*^9}, 
   3.946653713260479*^9, {3.947165880042204*^9, 3.947165891148058*^9}},
 CellLabel->
  "Out[102]=",ExpressionUUID->"6ebd37ac-8f5d-5e41-8ade-a8edf09d4ff7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["o[ABCD] = h[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 
  3.946656375757744*^9}},ExpressionUUID->"12b46a2f-8faa-d749-84a4-\
ba018f4bad56"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466579729008904`*^9, 3.94665802570725*^9}, 
   3.946661173503782*^9, 3.947165830774866*^9},
 CellLabel->
  "In[103]:=",ExpressionUUID->"f6b51686-071b-2e44-adac-6b40f4512532"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9466580320281744`*^9, 3.9466580467933273`*^9}, 
   3.946661177570804*^9, 3.947166101002905*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"b09e5cc3-d976-1a40-91ba-0d28310a04f0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["homot[ABCD, EFGH]", "Subsubsection",
 CellChangeTimes->{{3.94665661536796*^9, 
  3.94665661991645*^9}},ExpressionUUID->"3334e9c6-ef14-7f4b-aadf-\
e58d0512221a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466631820758085`*^9, 3.9466631844445066`*^9}, 
   3.947165851638054*^9},ExpressionUUID->"c7b86019-b229-f647-afc7-\
83ce9fcd6ca4"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946663350545542*^9},
 CellLabel->
  "Out[244]=",ExpressionUUID->"435e6127-13d9-264d-820b-8e457ad9a23b"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (382)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 3.9471644572466583`*^9}, {
   3.9471647716057224`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}, 3.9471652441100216`*^9, {3.9471653102785034`*^9, 
   3.947165310950321*^9}, {3.947165499885479*^9, 3.9471655007098846`*^9}, {
   3.947165712540951*^9, 3.9471657134614887`*^9}, {3.9471659457102165`*^9, 
   3.9471659457660675`*^9}},ExpressionUUID->"f3be3b97-83aa-194f-aa65-\
103abf5a651d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "382", "]"}]}]], "Input",
 CellChangeTimes->{{3.9471659806052*^9, 3.947165981229023*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"02cdcf91-46c9-c949-a744-bc29cef17346"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"10", " ", "q", " ", "r"}], "+", 
         RowBox[{"5", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"5", " ", "q"}], "-", 
            RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"5", " ", "q", " ", "r"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "-", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "-", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "-", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", 
              RowBox[{"2", " ", "q"}], "-", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p"}], "-", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
        ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"5", " ", "q", " ", "r"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"6", " ", "p", " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", 
         RowBox[{"3", " ", "q"}], "-", 
         RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "q"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "-", 
            RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "-", 
               RowBox[{"5", " ", "r"}]}], ")"}]}], "-", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"6", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "q"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "+", "q", "-", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", "p"}], "+", "q", "+", 
         RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p"}], "-", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p"}], "+", 
         RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", "p", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "+", 
         RowBox[{"5", " ", "p", " ", "r"}], "-", 
         RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"5", " ", "p", " ", "r"}], "+", 
         RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", "p"}], "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", 
         RowBox[{"2", " ", "q"}], "+", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "-", 
            RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p", " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"6", " ", "q", " ", "r"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "q"}], "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p"}], "+", "q", "-", 
         RowBox[{"2", " ", "r"}]}], ")"}], " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p"}], "+", "q", "+", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p", " ", "q"}], "+", 
         RowBox[{"6", " ", "p", " ", "r"}], "-", 
         RowBox[{"3", " ", "q", " ", "r"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p", " ", "q"}], "+", 
         RowBox[{"2", " ", "p", " ", "r"}], "+", 
         RowBox[{"4", " ", "q", " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p"}], "-", 
            RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "-", 
            RowBox[{"5", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5"}], " ", "p"}], "+", 
            RowBox[{"5", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947166109774906*^9},
 CellLabel->
  "Out[104]=",ExpressionUUID->"589db1ba-2b09-2245-b14e-5707abbbe3c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] / [EFGH] = 1/4", "Subsubsection",
 CellChangeTimes->{{3.946652229046633*^9, 3.9466522328834243`*^9}, {
  3.9466526961697435`*^9, 
  3.946652696754415*^9}},ExpressionUUID->"c9ea486b-c17e-1e43-9438-\
5dbe325f1ed6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], "/", 
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946652679226181*^9, 3.946652687466215*^9}, 
   3.9471659766704235`*^9},
 CellLabel->
  "In[105]:=",ExpressionUUID->"f88f6e39-c8b2-fa46-83cf-4e3486e3e910"],

Cell[BoxData[
 FractionBox["1", "4"]], "Output",
 CellChangeTimes->{3.946652701296688*^9, 3.947166113666689*^9},
 CellLabel->
  "Out[105]=",ExpressionUUID->"fec03a4f-bf95-774d-b952-d7a0ab024dc1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["anti[EFGH] = h[ABCD]", "Subsubsection",
 CellChangeTimes->{{3.9466523847340784`*^9, 
  3.946652389067072*^9}},ExpressionUUID->"0d5d274f-3447-b246-a70b-\
050006c97400"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946653338457144*^9, 3.946653355122055*^9}, 
   3.94716600206159*^9},
 CellLabel->
  "In[106]:=",ExpressionUUID->"271074b9-0a9a-1849-a270-146160c2bfef"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946653362883823*^9, 3.9471661213779964`*^9},
 CellLabel->
  "Out[106]=",ExpressionUUID->"f186d53c-9c65-c142-9edc-dff9b6890b4c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["o[ABCD] = h[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 
  3.946656375757744*^9}},ExpressionUUID->"6279313e-dd06-034f-b51c-\
57d868b841d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466579729008904`*^9, 3.94665802570725*^9}, 
   3.946661173503782*^9, 3.9471660260861206`*^9},
 CellLabel->
  "In[107]:=",ExpressionUUID->"9c461f3a-e74e-ea4e-b9cb-7f182dfaad31"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9466580320281744`*^9, 3.9466580467933273`*^9}, 
   3.946661177570804*^9, 3.9471663305621624`*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"346bbe16-a471-904c-84a2-643c0f1ee093"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["homot[ABCD, EFGH]", "Subsubsection",
 CellChangeTimes->{{3.94665661536796*^9, 
  3.94665661991645*^9}},ExpressionUUID->"4923394b-ef0a-4640-a910-\
ea43cc00ca49"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466631820758085`*^9, 3.9466631844445066`*^9}, 
   3.9471660462052193`*^9},
 CellLabel->
  "In[108]:=",ExpressionUUID->"60bb7c37-f0cf-3342-b145-51c03c6ec8a7"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946663350545542*^9, 3.947166440299814*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"b5ac87be-0a06-2c4c-b2a8-c55b8c1e87a2"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (399)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 3.9471644572466583`*^9}, {
   3.9471647716057224`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}, 3.9471652441100216`*^9, {3.9471653102785034`*^9, 
   3.947165310950321*^9}, {3.947165499885479*^9, 3.9471655007098846`*^9}, {
   3.947165712540951*^9, 3.9471657134614887`*^9}, {3.9471659457102165`*^9, 
   3.9471659457660675`*^9}, {3.947166207861828*^9, 
   3.9471662080054455`*^9}},ExpressionUUID->"b8d780b4-a95d-c743-86df-\
88958275099d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
   RowBox[{"CentralQuadrilateral", "[", "399", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9471662394376297`*^9, 3.94716624071698*^9}, 
   3.947166461205868*^9},
 CellLabel->
  "In[110]:=",ExpressionUUID->"b8dbe1b5-51d2-d241-934c-66461055ea0d"],

Cell["o[ABCD] = o[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 3.946656375757744*^9}, {
  3.947166228044956*^9, 
  3.947166228460848*^9}},ExpressionUUID->"78c1230f-5fcd-9a41-92cf-\
5bbc47a3de10"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9471664999332504`*^9, 3.9471665016775913`*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"4f51b4e9-da58-8646-90e1-74016aead79a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9471667677928505`*^9},
 CellLabel->
  "Out[111]=",ExpressionUUID->"0c06a6b5-9593-234a-9529-447fe3a32d40"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (546)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 3.9471644572466583`*^9}, {
   3.9471647716057224`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}, 3.9471652441100216`*^9, {3.9471653102785034`*^9, 
   3.947165310950321*^9}, {3.947165499885479*^9, 3.9471655007098846`*^9}, {
   3.947165712540951*^9, 3.9471657134614887`*^9}, {3.9471659457102165`*^9, 
   3.9471659457660675`*^9}, {3.947166207861828*^9, 3.9471662080054455`*^9}, {
   3.9471668733738956`*^9, 
   3.9471668750127068`*^9}},ExpressionUUID->"ecc512e7-5948-5349-ae30-\
9fa72d072904"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "546", "]"}]}]], "Input",
 CellChangeTimes->{3.9471668814620323`*^9},
 CellLabel->
  "In[112]:=",ExpressionUUID->"a3caacc3-5b86-a848-91b5-772003280e90"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"10", " ", "q", " ", "r"}], "+", 
         RowBox[{"5", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"5", " ", "q"}], "-", 
            RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"5", " ", "q", " ", "r"}], "+", 
         RowBox[{"3", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "-", "q", "-", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "+", 
            RowBox[{"7", " ", "p", " ", "q"}], "-", 
            RowBox[{"4", " ", "p", " ", "r"}], "-", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"7", " ", "p", " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "-", 
              RowBox[{"3", " ", "q"}], "-", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p"}], "+", 
              RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
        ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"5", " ", "q", " ", "r"}], "+", 
         RowBox[{"3", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "-", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", "r"}], "-", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", 
         RowBox[{"2", " ", "q"}], "+", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", 
            RowBox[{"6", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", "p", " ", "q"}], "+", 
            SuperscriptBox["q", "2"], "-", 
            RowBox[{"5", " ", "p", " ", "r"}], "-", 
            RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"6", " ", "q"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p"}], "+", "q", "-", 
         RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5"}], " ", "p"}], "+", "q", "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "p"}], "+", 
         RowBox[{"2", " ", "q"}], "-", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p"}], "+", 
         RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p", " ", "q"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"5", " ", "p", " ", "r"}], "+", 
         RowBox[{"6", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", "p", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "-", 
         RowBox[{"5", " ", "p", " ", "r"}], "+", 
         RowBox[{"7", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "p"}], "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "p", " ", "q"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", "r"}], "+", 
            RowBox[{"7", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", 
         RowBox[{"3", " ", "q"}], "-", 
         RowBox[{"2", " ", "r"}]}], ")"}], " ", "r"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"6", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5"}], " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", "r"}], "-", 
            RowBox[{"4", " ", "q", " ", "r"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "q"}], "+", 
               RowBox[{"6", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p"}], "+", "q", "-", 
         RowBox[{"2", " ", "r"}]}], ")"}], " ", "r"}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p"}], "+", "q", "+", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", "p", " ", "q"}], "-", 
         RowBox[{"4", " ", "p", " ", "r"}], "+", 
         RowBox[{"7", " ", "q", " ", "r"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p", " ", "q"}], "+", 
         RowBox[{"3", " ", "p", " ", "r"}], "+", 
         RowBox[{"6", " ", "q", " ", "r"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p", " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", "r"}], "+", 
            RowBox[{"7", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "-", 
            RowBox[{"5", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5"}], " ", "p"}], "+", 
            RowBox[{"5", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947166882162388*^9},
 CellLabel->
  "Out[112]=",ExpressionUUID->"23b8135f-df3e-4f4c-81fd-fe2494d39e42"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = [EFGH] = 16/9", "Subsubsection",
 CellChangeTimes->{{3.9466522457644024`*^9, 
  3.946652251171549*^9}},ExpressionUUID->"f302a771-49ea-364a-b511-\
1158b4491e51"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], "/", 
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946652728226715*^9, 3.946652728370693*^9}, {
  3.947166879103586*^9, 3.947166888541937*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"24541813-febc-3e42-82d8-541f72a566d4"]
}, Open  ]],

Cell[BoxData[
 FractionBox["16", "9"]], "Output",
 CellChangeTimes->{3.9466527294295382`*^9, 3.947166889441759*^9},
 CellLabel->
  "Out[113]=",ExpressionUUID->"e8ea0b6d-b579-3f49-bb69-d15f8cdf9267"],

Cell[CellGroupData[{

Cell["anti[ABCD] = centro[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946652334941677*^9, 
  3.9466523395722456`*^9}},ExpressionUUID->"45123282-c912-bd45-90d7-\
451fe16fee9a"],

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"AnticenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"CentrocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946653158578365*^9, 3.9466531732737265`*^9}, 
   3.947166915197136*^9},
 CellLabel->
  "In[114]:=",ExpressionUUID->"5c120448-6d08-bf49-9268-c35d48193195"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946653182751196*^9, 3.947166925568884*^9},
 CellLabel->
  "Out[114]=",ExpressionUUID->"18329894-4a15-4b40-a211-4934d3f0a5b5"],

Cell[CellGroupData[{

Cell["o[ABCD] = h[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 
  3.946656375757744*^9}},ExpressionUUID->"10e892c7-d40b-a34d-ad74-\
505efaabfb9d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466579729008904`*^9, 3.94665802570725*^9}, 
   3.946661173503782*^9, 3.9471669494539337`*^9},
 CellLabel->
  "In[115]:=",ExpressionUUID->"c9a719ee-179e-344b-812e-b6d6f60e81c8"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9466580320281744`*^9, 3.9466580467933273`*^9}, 
   3.946661177570804*^9, 3.9471671721796017`*^9},
 CellLabel->
  "Out[115]=",ExpressionUUID->"b0826520-229d-f241-bb7c-7120e5e7935f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["homot[ABCD, EFGH]", "Subsubsection",
 CellChangeTimes->{{3.94665661536796*^9, 
  3.94665661991645*^9}},ExpressionUUID->"07ad83c4-bb0c-cd44-bbf4-\
fdf2f512098e"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466631820758085`*^9, 3.9466631844445066`*^9}, 
   3.947166976973625*^9},
 CellLabel->
  "In[116]:=",ExpressionUUID->"1d9b2697-2a32-ed44-ba3e-bc59e5d3dc15"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946663350545542*^9, 3.9471671975323067`*^9},
 CellLabel->
  "Out[116]=",ExpressionUUID->"0d205ce7-fb1c-3a4a-b858-93f0b9b9ba04"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (547)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 3.9471644572466583`*^9}, {
   3.9471647716057224`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}, 3.9471652441100216`*^9, {3.9471653102785034`*^9, 
   3.947165310950321*^9}, {3.947165499885479*^9, 3.9471655007098846`*^9}, {
   3.947165712540951*^9, 3.9471657134614887`*^9}, {3.9471659457102165`*^9, 
   3.9471659457660675`*^9}, {3.947166207861828*^9, 3.9471662080054455`*^9}, {
   3.9471668733738956`*^9, 3.9471668750127068`*^9}, {3.947167224549305*^9, 
   3.9471672246209927`*^9}},ExpressionUUID->"8734c32f-a316-424f-8085-\
68dedf28629d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "547", "]"}]}]], "Input",
 CellChangeTimes->{{3.947167265501278*^9, 3.9471672661804104`*^9}},
 CellLabel->
  "In[117]:=",ExpressionUUID->"458e6227-426e-484c-b96b-8243c6927117"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"]}], "-", 
         RowBox[{"6", " ", "q", " ", "r"}], "-", 
         RowBox[{"3", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}], "-", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", "p"}], "-", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"3", " ", "q", " ", "r"}], "+", 
         RowBox[{"5", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"7", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "+", 
            RowBox[{"7", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"17", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "-", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"17", " ", "p", " ", "q"}], "+", 
            RowBox[{"10", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"3", " ", "q", " ", "r"}], "+", 
         RowBox[{"5", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "+", 
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"7", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"17", " ", "p", " ", "r"}], "-", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"10", " ", "p", " ", "q"}], "+", 
            RowBox[{"17", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "p"}], "+", 
         RowBox[{"2", " ", "q"}], "+", 
         RowBox[{"5", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"14", " ", "p"}], "+", 
            RowBox[{"7", " ", "q"}], "+", 
            RowBox[{"10", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"17", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", "p"}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"10", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "p"}], "-", 
         RowBox[{"7", " ", "q"}], "+", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p", " ", "q"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"6", " ", "p", " ", "r"}], "+", 
         RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"10", " ", 
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "p"}], "+", 
            RowBox[{"7", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p"}], "+", 
         RowBox[{"2", " ", "q"}], "+", 
         RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p"}], "+", 
         RowBox[{"5", " ", "q"}], "+", 
         RowBox[{"7", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "p", " ", "q"}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["q", "2"]}], "-", 
         RowBox[{"3", " ", "p", " ", "r"}], "+", 
         RowBox[{"17", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10", " ", "p"}], "+", 
            RowBox[{"7", " ", "q"}], "+", 
            RowBox[{"14", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10", " ", "p", " ", "q"}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"17", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "p"}], "+", 
         RowBox[{"5", " ", "q"}], "+", 
         RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"14", " ", "p"}], "+", 
            RowBox[{"10", " ", "q"}], "+", 
            RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "-", 
            RowBox[{"17", " ", "p", " ", "r"}], "-", 
            RowBox[{"4", " ", "q", " ", "r"}], "-", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", "p"}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"10", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p"}], "+", 
         RowBox[{"7", " ", "q"}], "+", 
         RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p"}], "+", 
         RowBox[{"7", " ", "q"}], "+", 
         RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p", " ", "q"}], "-", 
         RowBox[{"4", " ", "p", " ", "r"}], "-", 
         RowBox[{"17", " ", "q", " ", "r"}], "-", 
         RowBox[{"7", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10", " ", "p"}], "+", 
            RowBox[{"14", " ", "q"}], "+", 
            RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"10", " ", "p", " ", "r"}], "+", 
            RowBox[{"17", " ", "q", " ", "r"}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "-", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", "r"}], "+", 
         RowBox[{"3", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "-", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"7", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"10", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9471672670025673`*^9},
 CellLabel->
  "Out[117]=",ExpressionUUID->"346585a9-6be1-2f49-9ebf-8cd6b11d1e3e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = [EFGH] = 144/25", "Subsubsection",
 CellChangeTimes->{{3.94665226694873*^9, 
  3.946652272643329*^9}},ExpressionUUID->"db0a1636-b5b9-4746-a827-\
a40669be75ea"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], "/", 
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.94665274398612*^9, 3.9466527458189526`*^9}, 
   3.9471672621511974`*^9},
 CellLabel->
  "In[118]:=",ExpressionUUID->"815e2e87-2f95-5a4c-8b80-325282f4d1c6"]
}, Open  ]],

Cell[BoxData[
 FractionBox["144", "25"]], "Output",
 CellChangeTimes->{3.9466527467492104`*^9, 3.947167268949272*^9},
 CellLabel->
  "Out[118]=",ExpressionUUID->"1b917f5e-b5b2-5f4d-8796-816cc272f99b"],

Cell[CellGroupData[{

Cell["o[ABCD] = h[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 
  3.946656375757744*^9}},ExpressionUUID->"d59ac7ac-3d5f-cd44-8964-\
040dce9582d7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466579729008904`*^9, 3.94665802570725*^9}, 
   3.946661173503782*^9, 3.9471673007015934`*^9},
 CellLabel->
  "In[119]:=",ExpressionUUID->"9b3fe2f1-9a97-0a4b-8071-2e6534f9a826"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9466580320281744`*^9, 3.9466580467933273`*^9}, 
   3.946661177570804*^9, 3.9471674818263874`*^9},
 CellLabel->
  "Out[119]=",ExpressionUUID->"ff7625c7-50f5-594e-bdc8-473b3b26249d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["homot[ABCD, EFGH]", "Subsubsection",
 CellChangeTimes->{{3.94665661536796*^9, 
  3.94665661991645*^9}},ExpressionUUID->"e5929883-4c74-3648-98b7-\
c2058f8a516e"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466631820758085`*^9, 3.9466631844445066`*^9}, 
   3.947167346869255*^9},
 CellLabel->
  "In[120]:=",ExpressionUUID->"3f81d2cf-a727-974e-b0e9-57928e7621f2"]
}, Open  ]],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946663350545542*^9, 3.947167570769434*^9},
 CellLabel->
  "Out[120]=",ExpressionUUID->"be692aea-7b17-ca4f-88b0-0f00954a23d7"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (548)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 3.9471644572466583`*^9}, {
   3.9471647716057224`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}, 3.9471652441100216`*^9, {3.9471653102785034`*^9, 
   3.947165310950321*^9}, {3.947165499885479*^9, 3.9471655007098846`*^9}, {
   3.947165712540951*^9, 3.9471657134614887`*^9}, {3.9471659457102165`*^9, 
   3.9471659457660675`*^9}, {3.947166207861828*^9, 3.9471662080054455`*^9}, {
   3.9471668733738956`*^9, 3.9471668750127068`*^9}, {3.947167224549305*^9, 
   3.9471672246209927`*^9}, {3.9471675968043365`*^9, 
   3.947167596876753*^9}},ExpressionUUID->"7201935d-7520-2d4b-9886-\
7e45e0048868"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "548", "]"}]}]], "Input",
 CellChangeTimes->{3.947170276659519*^9},
 CellLabel->
  "In[121]:=",ExpressionUUID->"86c3a276-be4c-0846-a4c2-539d1003cc3b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"14", " ", "q", " ", "r"}], "+", 
         RowBox[{"7", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "+", 
            RowBox[{"7", " ", "q"}], "-", 
            RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "-", 
            RowBox[{"7", " ", "q"}], "+", 
            RowBox[{"7", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "p"}], "+", 
            RowBox[{"5", " ", "q"}], "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"5", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"7", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"7", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"7", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "-", 
            RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "p"}], "-", "q", "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"7", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p"}], "+", 
         RowBox[{"6", " ", "q"}], "-", "r"}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5"}], " ", "p"}], "+", "q", "+", "r"}], ")"}]}], 
         "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"7", " ", "p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10", " ", "p"}], "+", 
            RowBox[{"5", " ", "q"}], "-", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", "p", " ", "r"}], "+", 
            RowBox[{"12", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "p"}], "-", 
         RowBox[{"5", " ", "q"}], "-", 
         RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "7"}], " ", "p"}], "-", 
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"7", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "q"}], "+", 
            RowBox[{"7", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "-", 
         RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "p"}], "+", 
         RowBox[{"6", " ", "q"}], "+", 
         RowBox[{"5", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "+", 
         RowBox[{"7", " ", "p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"12", " ", "p", " ", "q"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"7", " ", "p", " ", "r"}], "+", 
         RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", "p", " ", "r"}], "-", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "-", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p"}], "-", "q", "+", 
         RowBox[{"6", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "-", "q", "-", "r"}], ")"}], " ", "r"}], 
         "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10", " ", "p"}], "-", 
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"12", " ", "q", " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", 
         RowBox[{"5", " ", "q"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "p"}], "+", 
         RowBox[{"5", " ", "q"}], "+", 
         RowBox[{"6", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "p", " ", "q"}], "+", 
         RowBox[{"12", " ", "p", " ", "r"}], "+", 
         RowBox[{"3", " ", "q", " ", "r"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "-", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], "2"]}], " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", "p"}], "-", 
            RowBox[{"7", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "7"}], " ", "p"}], "+", 
            RowBox[{"7", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", "q"}], "+", 
            RowBox[{"6", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "5"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947170277537081*^9},
 CellLabel->
  "Out[121]=",ExpressionUUID->"928d50de-e6b7-cf49-9c17-95b1e683904d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = 16[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946652159004984*^9, 
  3.9466521640915127`*^9}},ExpressionUUID->"c3292f07-8e17-9846-a0e7-\
59ad5df6ce47"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], "-", 
    RowBox[{"16", 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}]}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466526339462333`*^9, 3.94665263861812*^9}, {
  3.947170273174698*^9, 3.9471702871873016`*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"edd1f79e-f596-5146-b687-d4d3ec2be568"]
}, Open  ]],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.946652639654703*^9, 3.9471702881582737`*^9},
 CellLabel->
  "Out[122]=",ExpressionUUID->"1a08d3b9-ef85-504e-802d-f92518ad97c2"],

Cell[CellGroupData[{

Cell["o[ABCD] = h[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 
  3.946656375757744*^9}},ExpressionUUID->"fa371685-c880-644e-be5c-\
539022d99e8d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466579729008904`*^9, 3.94665802570725*^9}, 
   3.946661173503782*^9, {3.9471703203642197`*^9, 3.947170320508358*^9}},
 CellLabel->
  "In[123]:=",ExpressionUUID->"014d41cb-03c3-964a-a487-1041d4380e87"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9466580320281744`*^9, 3.9466580467933273`*^9}, 
   3.946661177570804*^9, 3.9471705131953144`*^9},
 CellLabel->
  "Out[123]=",ExpressionUUID->"7b36c1c3-1609-4d40-a1a3-70621cb1169b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["homot[ABCD, EFGH]", "Subsubsection",
 CellChangeTimes->{{3.94665661536796*^9, 
  3.94665661991645*^9}},ExpressionUUID->"0f034748-3e2c-934f-a780-\
9266a588840a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466631820758085`*^9, 3.9466631844445066`*^9}, 
   3.9471703560281105`*^9},
 CellLabel->
  "In[124]:=",ExpressionUUID->"e9f30c75-c363-c143-b23e-f0b882d27a37"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946663350545542*^9, 3.9471705595098*^9},
 CellLabel->
  "Out[124]=",ExpressionUUID->"396b562d-0224-2845-99da-5d14177cd5dc"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (549)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 3.9471644572466583`*^9}, {
   3.9471647716057224`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}, 3.9471652441100216`*^9, {3.9471653102785034`*^9, 
   3.947165310950321*^9}, {3.947165499885479*^9, 3.9471655007098846`*^9}, {
   3.947165712540951*^9, 3.9471657134614887`*^9}, {3.9471659457102165`*^9, 
   3.9471659457660675`*^9}, {3.947166207861828*^9, 3.9471662080054455`*^9}, {
   3.9471668733738956`*^9, 3.9471668750127068`*^9}, {3.947167224549305*^9, 
   3.9471672246209927`*^9}, {3.9471675968043365`*^9, 3.947167596876753*^9}, {
   3.947170375139847*^9, 
   3.9471703752435284`*^9}},ExpressionUUID->"2858d55b-424a-7645-b79e-\
f2681d2c984e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "549", "]"}]}]], "Input",
 CellChangeTimes->{{3.9471704051881237`*^9, 3.94717040534766*^9}},
 CellLabel->
  "In[125]:=",ExpressionUUID->"dc08e476-d6c1-fa42-889c-c8649e6a4dff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"6", " ", "q", " ", "r"}], "+", 
         RowBox[{"3", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}], "-", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "-", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"5", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p"}], "+", 
            RowBox[{"5", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"7", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"7", " ", "p", " ", "q"}], "+", 
            RowBox[{"8", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p"}], "+", "q", "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", "r"}], "-", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"8", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p"}], "+", 
         RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            SuperscriptBox["q", "2"], "-", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10", " ", "p"}], "+", 
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", "p", " ", "q"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"8", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"5", " ", "q"}], "-", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p"}], "-", 
         RowBox[{"5", " ", "q"}], "-", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p", " ", "q"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"6", " ", "p", " ", "r"}], "+", 
         RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "+", 
         RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", 
         RowBox[{"4", " ", "q"}], "+", 
         RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "-", 
         RowBox[{"3", " ", "p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", "p", " ", "q"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"3", " ", "p", " ", "r"}], "+", 
         RowBox[{"7", " ", "q", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"10", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"7", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p"}], "+", "q", "+", 
         RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"10", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", "r"}], "+", 
            RowBox[{"8", " ", "q", " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "-", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", 
         RowBox[{"5", " ", "q"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", 
         RowBox[{"5", " ", "q"}], "+", 
         RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p", " ", "q"}], "+", 
         RowBox[{"8", " ", "p", " ", "r"}], "+", 
         RowBox[{"7", " ", "q", " ", "r"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"10", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"7", " ", "q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "-", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947170579099621*^9},
 CellLabel->
  "Out[125]=",ExpressionUUID->"6592c301-1b50-e04a-bdf2-4f6f2c5531b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = 36[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946652173324858*^9, 
  3.946652177307232*^9}},ExpressionUUID->"2c984104-c42d-0441-afbb-\
fc8ac0998b30"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], "-", 
    RowBox[{"36", 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}]}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.946652667850227*^9, 3.9466526723391676`*^9}, 
   3.9471704007489014`*^9},
 CellLabel->
  "In[126]:=",ExpressionUUID->"52ff8c03-796e-8f40-98b1-c71004e01c93"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.946652672766489*^9, 3.947170580861805*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"f9bc99db-62fb-5f44-b776-d2ccacf38bbe"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["o[ABCD] = h[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 
  3.946656375757744*^9}},ExpressionUUID->"03add8ef-ea88-834a-82cd-\
9046c152c3b7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466579729008904`*^9, 3.94665802570725*^9}, 
   3.946661173503782*^9, 3.9471704264197235`*^9},
 CellLabel->
  "In[127]:=",ExpressionUUID->"6f806cb2-8552-024c-b716-0bb099543115"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9466580320281744`*^9, 3.9466580467933273`*^9}, 
   3.946661177570804*^9, 3.947170803229147*^9},
 CellLabel->
  "Out[127]=",ExpressionUUID->"03a3a557-8869-ab4e-b248-69c1a5ccb372"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["homot[ABCD, EFGH]", "Subsubsection",
 CellChangeTimes->{{3.94665661536796*^9, 
  3.94665661991645*^9}},ExpressionUUID->"d7508fa3-fc93-df4a-abdd-\
d4bc97142765"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466631820758085`*^9, 3.9466631844445066`*^9}, 
   3.9471704462520504`*^9},
 CellLabel->
  "In[128]:=",ExpressionUUID->"8d09cd92-3a90-3a4c-a555-dd1ed4aa3afd"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946663350545542*^9, 3.947170893482071*^9},
 CellLabel->
  "Out[128]=",ExpressionUUID->"966cdf23-3e75-a14e-a209-9bae328bfaa7"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (550)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 3.9471644572466583`*^9}, {
   3.9471647716057224`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}, 3.9471652441100216`*^9, {3.9471653102785034`*^9, 
   3.947165310950321*^9}, {3.947165499885479*^9, 3.9471655007098846`*^9}, {
   3.947165712540951*^9, 3.9471657134614887`*^9}, {3.9471659457102165`*^9, 
   3.9471659457660675`*^9}, {3.947166207861828*^9, 3.9471662080054455`*^9}, {
   3.9471668733738956`*^9, 3.9471668750127068`*^9}, {3.947167224549305*^9, 
   3.9471672246209927`*^9}, {3.9471675968043365`*^9, 3.947167596876753*^9}, {
   3.947170375139847*^9, 3.9471703752435284`*^9}, {3.947170464715393*^9, 
   3.9471704647712746`*^9}},ExpressionUUID->"ad9a5490-9f85-1548-a296-\
e7982780fbb2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "550", "]"}]}]], "Input",
 CellChangeTimes->{{3.947170499451515*^9, 3.947170500099783*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"66c2127e-5ad9-b64a-84ed-fc1ff2f81ede"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], " ", 
       SuperscriptBox["p", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"10", " ", "q", " ", "r"}], "+", 
         RowBox[{"5", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"5", " ", "q"}], "-", 
            RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "-", 
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}], "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"5", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"8", " ", "p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         RowBox[{"5", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "-", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p"}], "-", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"8", " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"5", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p"}], "+", 
         RowBox[{"4", " ", "q"}], "-", "r"}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "p"}], "+", "q", "+", "r"}], ")"}]}], 
         "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"5", " ", "p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}], "-", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", "r"}], "+", 
            RowBox[{"8", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p"}], "-", 
         RowBox[{"3", " ", "q"}], "-", 
         RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5"}], " ", "p"}], "-", 
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "q"}], "+", 
            RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "-", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "p"}], "+", 
         RowBox[{"4", " ", "q"}], "+", 
         RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", "p", " ", "q"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"5", " ", "p", " ", "r"}], "+", 
         RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "+", 
         RowBox[{"5", " ", "p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "-", 
            RowBox[{"3", " ", "q"}], "-", 
            RowBox[{"6", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "p"}], "-", "q", "+", 
         RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "-", "q", "-", "r"}], ")"}], " ", "r"}], 
         "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", "p"}], "-", 
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"8", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "4"]}], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", 
         RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "p"}], "+", 
         RowBox[{"3", " ", "q"}], "+", 
         RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p", " ", "q"}], "+", 
         RowBox[{"8", " ", "p", " ", "r"}], "+", 
         RowBox[{"q", " ", "r"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "-", 
            RowBox[{"6", " ", "q"}], "-", 
            RowBox[{"3", " ", "r"}]}], ")"}], " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], "2"]}], " ", 
       SuperscriptBox["r", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "p"}], "-", 
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "5"}], " ", "p"}], "+", 
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "q"}], "+", 
            RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox["b", "4"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947171557178747*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"49f75cd2-b8e0-da47-8ab9-d51652e91fcc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["[ABCD] = 4[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946652144869679*^9, 
  3.946652145990576*^9}},ExpressionUUID->"f7bbb158-2d83-7e43-bf9c-\
69571c7dede7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AreaQuad", "[", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], "-", 
    RowBox[{"4", 
     RowBox[{"AreaQuad", "[", 
      RowBox[{"{", 
       RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}]}]}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.94665257041349*^9, 3.946652592170067*^9}, {
  3.947170494835636*^9, 3.947170495725258*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"4704dc0d-b10b-ba46-aac4-748e940e2f22"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.946652583481933*^9, 3.9471715598369713`*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"5b8cacd6-4896-ec43-ae5b-1ee46e661679"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["o[ABCD] = h[EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946656362528492*^9, 
  3.946656375757744*^9}},ExpressionUUID->"f92048ef-660e-df47-8585-\
84a876b2f045"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EqualPointsQ", "[", 
  RowBox[{
   RowBox[{"CircumcenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}], ",", 
   RowBox[{"OrthocenterQuad", "[", 
    RowBox[{"{", 
     RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "]"}], ",", 
   "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466579729008904`*^9, 3.94665802570725*^9}, 
   3.946661173503782*^9, 3.947170525219696*^9},
 CellLabel->"In[53]:=",ExpressionUUID->"57c82143-e594-1749-9dc0-abdc98a29a58"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9466580320281734`*^9, 3.9466580467933273`*^9}, 
   3.946661177570804*^9, 3.9471717489608727`*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"0f15415d-1ed0-ca45-a453-49dd2c82bef8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["homot[ABCD, EFGH]", "Subsubsection",
 CellChangeTimes->{{3.94665661536796*^9, 
  3.94665661991645*^9}},ExpressionUUID->"77219185-d7d4-da4d-a111-\
8cad09e3538f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], 
   ",", "cyclic"}], "]"}]], "Input",
 CellChangeTimes->{{3.9466631820758076`*^9, 3.9466631844445057`*^9}, 
   3.947170546580143*^9},
 CellLabel->"In[54]:=",ExpressionUUID->"42e8d0ff-73a9-ef48-9c28-5a5e86163d29"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946663350545542*^9, 3.94717184138402*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"c6637434-7e6d-7241-a615-1c38ba71d524"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (631)", "Subsection",
 CellChangeTimes->{{3.946651916405796*^9, 3.946651920884935*^9}, 
   3.9471631787668095`*^9, 3.9471633916954575`*^9, {3.9471637872300644`*^9, 
   3.9471637872867393`*^9}, {3.947164457181654*^9, 3.9471644572466583`*^9}, {
   3.9471647716057224`*^9, 3.947164771662615*^9}, {3.9471651343021545`*^9, 
   3.94716513567799*^9}, 3.9471652441100216`*^9, {3.9471653102785034`*^9, 
   3.947165310950321*^9}, {3.947165499885479*^9, 3.9471655007098846`*^9}, {
   3.947165712540951*^9, 3.9471657134614887`*^9}, {3.9471659457102165`*^9, 
   3.9471659457660675`*^9}, {3.947166207861828*^9, 3.9471662080054455`*^9}, {
   3.9471668733738956`*^9, 3.9471668750127068`*^9}, {3.947167224549305*^9, 
   3.9471672246209927`*^9}, {3.9471675968043365`*^9, 3.947167596876753*^9}, {
   3.947170375139847*^9, 3.9471703752435284`*^9}, {3.947170464715393*^9, 
   3.9471704647712746`*^9}, {3.947170645011263*^9, 
   3.947170645723345*^9}},ExpressionUUID->"8a00671f-2e67-1a43-bd92-\
277cd39b1f5b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "631", "]"}]}]], "Input",
 CellChangeTimes->{{3.9471718993957253`*^9, 3.9471718996910954`*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"fc0cfbea-bd48-8d4e-88b8-1c98052ed7bf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["p", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "-", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "-", "q", "+", "r"}], ")"}]}]}], ")"}]}],
       "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         RowBox[{"4", " ", "q", " ", "r"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"2", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "-", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}]}], 
        ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"2", " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", 
            RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "2"], "-", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", "p"}], "+", 
         RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "-", "r"}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["q", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox["q", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "q"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "-", "r"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "p"}], "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"4", " ", "p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", "q", "+", 
         RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"p", "+", 
         RowBox[{"3", " ", "q"}], "+", 
         RowBox[{"4", " ", "r"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "-", 
         RowBox[{"2", " ", "p", " ", "r"}], "+", 
         RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox